/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.mounts;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.cosmetics.mounts.MountAbstractHorse;
import be.isach.ultracosmetics.cosmetics.type.MountType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.PlayerUtils;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import java.awt.Color;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class MountRudolph
extends MountAbstractHorse {
    private static final ItemStack DEAD_BUSH = XMaterial.DEAD_BUSH.parseItem();
    private final ParticleDisplay nose = ParticleDisplay.of((XParticle)XParticle.DUST).withColor(Color.RED);
    private ArmorStand left;
    private ArmorStand right;

    public MountRudolph(UltraPlayer owner, MountType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void setupEntity() {
        super.setupEntity();
        this.left = this.spawnArmorStand(false);
        this.right = this.spawnArmorStand(true);
        this.moveAntlers();
    }

    private ArmorStand spawnArmorStand(boolean right) {
        ArmorStand armorStand = (ArmorStand)this.getEntity().getWorld().spawn(this.getEyeLocation(), ArmorStand.class);
        armorStand.setBasePlate(false);
        armorStand.setGravity(false);
        armorStand.setArms(true);
        armorStand.setVisible(false);
        if (!right) {
            armorStand.setRightArmPose(new EulerAngle(Math.PI, 0.7853981633974483, -0.7853981633974483));
        } else {
            armorStand.setRightArmPose(new EulerAngle(Math.PI, -0.7853981633974483, 0.7853981633974483));
        }
        armorStand.getEquipment().setItemInMainHand(DEAD_BUSH);
        armorStand.setPersistent(false);
        armorStand.setMetadata("C_AD_ArmorStand", (MetadataValue)new FixedMetadataValue((Plugin)this.getUltraCosmetics(), (Object)this.getPlayer().getUniqueId().toString()));
        return armorStand;
    }

    @Override
    public void onUpdate() {
        if (this.left != null && this.right != null) {
            this.moveAntlers();
        }
    }

    private void moveAntlers() {
        Location location = this.getEyeLocation();
        double radians = Math.toRadians(location.getYaw());
        Vector leftVector = new Vector(Math.cos(radians), 0.0, Math.sin(radians)).multiply(0.5);
        Vector rightVector = leftVector.clone().multiply(0.4);
        leftVector.multiply(1.6);
        location.add(PlayerUtils.getHorizontalDirection(this.getPlayer(), 0.75)).subtract(0.0, 1.7, 0.0);
        this.getUltraCosmetics().getScheduler().teleportAsync((Entity)this.left, location.clone().add(leftVector));
        this.getUltraCosmetics().getScheduler().teleportAsync((Entity)this.right, location.clone().add(rightVector));
        Location noseLocation = this.getEyeLocation();
        double y = noseLocation.getY();
        noseLocation.add(noseLocation.getDirection().multiply(1.15));
        noseLocation.setY(y + 0.127);
        this.nose.spawn(noseLocation);
        if (!UltraCosmeticsData.get().getVersionManager().isUsingNMS()) {
            return;
        }
        new Thread(() -> {
            for (Player player : this.getPlayer().getWorld().getPlayers()) {
                if (noseLocation.distanceSquared(player.getLocation()) > 1024.0) continue;
                UltraCosmeticsData.get().getVersionManager().getEntityUtil().sendTeleportPacket(player, (Entity)this.right);
                UltraCosmeticsData.get().getVersionManager().getEntityUtil().sendTeleportPacket(player, (Entity)this.left);
            }
        }).start();
    }

    @Override
    public void onClear() {
        super.onClear();
        if (this.left != null) {
            this.left.remove();
        }
        if (this.right != null) {
            this.right.remove();
        }
    }

    private Location getEyeLocation() {
        return ((LivingEntity)this.entity).getEyeLocation();
    }
}

