/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.particleeffects;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.Cosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.type.ParticleEffectType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class ParticleEffect
extends Cosmetic<ParticleEffectType>
implements Updatable {
    protected boolean displayIfStanding = true;
    protected boolean displayIfMoving = true;
    protected boolean useAlternativeEffect = false;
    protected Location lastLocation = null;
    protected boolean moving = true;
    protected boolean update = true;
    protected final ParticleDisplay display = ParticleDisplay.of((XParticle)((ParticleEffectType)this.getType()).getEffect());
    protected final ParticleDisplay alternativeEffect = this.display.copy().offset(0.2).withCount(this.getModifiedAmount(3)).withLocationCaller(() -> this.getPlayer().getLocation().add(0.0, 0.2, 0.0));

    public ParticleEffect(UltraPlayer ultraPlayer, ParticleEffectType type, UltraCosmetics ultraCosmetics) {
        super(ultraPlayer, type, ultraCosmetics);
    }

    @Override
    protected void onEquip() {
        if (this.getUltraCosmetics().getPaperSupport().hasParticlesDisabled(this.getPlayer())) {
            MessageManager.send((CommandSender)this.getPlayer(), "Particles-Minimal-In-Client", new TagResolver.Single[0]);
        }
    }

    @Override
    protected void scheduleTask() {
        this.task = this.getUltraCosmetics().getScheduler().runTimerAsync(this::run, 0L, (long)((ParticleEffectType)this.getType()).getRepeatDelay());
    }

    protected boolean locEquals(Location a, Location b) {
        if (a == null || b == null) {
            return false;
        }
        return a.getX() == b.getX() && a.getY() == b.getY() && a.getZ() == b.getZ();
    }

    @Override
    public void run() {
        Player player = this.getPlayer();
        if (player == null || this.getOwner().getCurrentParticleEffect() != this) {
            this.task.cancel();
            return;
        }
        if (this.update) {
            this.moving = !this.locEquals(this.lastLocation, player.getLocation());
            this.lastLocation = player.getLocation();
            if (((ParticleEffectType)this.getType()).getRepeatDelay() == 1) {
                this.update = false;
            }
        } else {
            this.update = true;
        }
        if (!this.isMoving()) {
            if (this.displayIfStanding) {
                this.onUpdate();
            }
            return;
        }
        if (!this.displayIfMoving) {
            return;
        }
        if (this.useAlternativeEffect) {
            this.showAlternativeEffect();
        } else {
            this.onUpdate();
        }
    }

    protected boolean isMoving() {
        return this.moving;
    }

    protected int getModifiedAmount(int originalAmount) {
        return Integer.max((int)((double)originalAmount * ((ParticleEffectType)this.getType()).getParticleMultiplier()), 1);
    }

    public void showAlternativeEffect() {
        this.alternativeEffect.spawn();
    }
}

