/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.particleeffects;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffect;
import be.isach.ultracosmetics.cosmetics.type.ParticleEffectType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.MathUtils;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class ParticleEffectFlameFairy
extends ParticleEffect {
    private final ParticleDisplay lavaDisplay = ParticleDisplay.of((XParticle)XParticle.LAVA);
    private final ParticleDisplay flameDisplay = ParticleDisplay.of((XParticle)XParticle.FLAME);
    private Vector targetDirection = new Vector(1, 0, 0);
    private Location currentLocation = this.getPlayer().getLocation();
    private Location targetLocation = this.generateNewTarget();
    private double noMoveTime = 0.0;
    private double movementSpeed = 0.2;

    public ParticleEffectFlameFairy(UltraPlayer owner, ParticleEffectType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
        this.lavaDisplay.withLocationCaller(() -> this.currentLocation);
        this.flameDisplay.withLocationCaller(() -> this.currentLocation);
    }

    @Override
    public void onUpdate() {
        if (this.getPlayer().getWorld() != this.currentLocation.getWorld() || this.getPlayer().getWorld() != this.targetLocation.getWorld()) {
            this.currentLocation = this.getPlayer().getLocation();
            this.targetLocation = this.generateNewTarget();
        }
        double distanceBtw = this.getPlayer().getEyeLocation().distance(this.currentLocation);
        double distTarget = this.currentLocation.distanceSquared(this.targetLocation);
        if (distTarget < 1.0 || distanceBtw > 3.0) {
            this.targetLocation = this.generateNewTarget();
            distTarget = this.currentLocation.distanceSquared(this.targetLocation);
        }
        if (RANDOM.nextDouble() > 0.98) {
            this.noMoveTime = (double)System.currentTimeMillis() + MathUtils.randomDouble(0.0, 2000.0);
        }
        if (this.getPlayer().getEyeLocation().distanceSquared(this.currentLocation) < 9.0) {
            this.movementSpeed = this.noMoveTime > (double)System.currentTimeMillis() ? Math.max(0.0, this.movementSpeed - 0.0075) : Math.min(0.1, this.movementSpeed + 0.0075);
        } else {
            this.noMoveTime = 0.0;
            this.movementSpeed = Math.min(0.15 + distanceBtw * 0.05, this.movementSpeed + 0.02);
        }
        this.targetDirection.add(this.targetLocation.toVector().subtract(this.currentLocation.toVector()).multiply(0.2));
        if (this.targetDirection.length() < 1.0) {
            this.movementSpeed *= this.targetDirection.length();
        }
        this.targetDirection = this.targetDirection.normalize();
        if (distTarget > 0.010000000000000002) {
            this.currentLocation.add(this.targetDirection.clone().multiply(this.movementSpeed));
        }
        this.lavaDisplay.spawn();
        this.flameDisplay.spawn();
    }

    private Location generateNewTarget() {
        return this.getPlayer().getEyeLocation().add((double)(RANDOM.nextInt(6) - 3), RANDOM.nextDouble() * 1.5, (double)(RANDOM.nextInt(6) - 3));
    }
}

