/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.projectileeffects;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Cosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.type.ProjectileEffectType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.ProjectileLaunchEvent;

public abstract class ProjectileEffect
extends Cosmetic<ProjectileEffectType>
implements Updatable {
    private final Map<Projectile, Location> projectiles = new HashMap<Projectile, Location>();
    private final Set<EntityType> types = new HashSet<EntityType>();
    protected final ParticleDisplay display = ParticleDisplay.of((XParticle)((ProjectileEffectType)this.getType()).getEffect());

    public ProjectileEffect(UltraPlayer owner, ProjectileEffectType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
        for (String entity : SettingsManager.getConfig().getStringList("Projectile-Types")) {
            try {
                this.types.add(EntityType.valueOf((String)entity.toUpperCase(Locale.ROOT)));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Override
    protected void onEquip() {
        if (this.getUltraCosmetics().getPaperSupport().hasParticlesDisabled(this.getPlayer())) {
            MessageManager.send((CommandSender)this.getPlayer(), "Particles-Minimal-In-Client", new TagResolver.Single[0]);
        }
    }

    @Override
    protected void scheduleTask() {
        this.task = this.getUltraCosmetics().getScheduler().runAtEntityTimer((Entity)this.getPlayer(), this::run, 0L, (long)((ProjectileEffectType)this.getType()).getRepeatDelay());
    }

    @EventHandler
    public void onShoot(ProjectileLaunchEvent event) {
        if (event.getEntity().getShooter() != this.getPlayer()) {
            return;
        }
        if (!this.types.contains(event.getEntityType())) {
            return;
        }
        this.projectiles.put(event.getEntity(), null);
    }

    @Override
    public void onUpdate() {
        Iterator<Map.Entry<Projectile, Location>> iter = this.projectiles.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Projectile, Location> entry = iter.next();
            Projectile proj = entry.getKey();
            if (!proj.isValid() || proj.getLocation().equals((Object)entry.getValue())) {
                iter.remove();
                continue;
            }
            this.showParticles(proj);
        }
        this.projectiles.replaceAll((p, l) -> p.getLocation());
    }

    @Override
    public void onClear() {
        this.projectiles.keySet().forEach(this::projectileLanded);
        this.projectiles.clear();
    }

    public abstract void showParticles(Projectile var1);

    public void projectileLanded(Projectile projectile) {
    }
}

