/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.suits;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.suits.ArmorSlot;
import be.isach.ultracosmetics.cosmetics.suits.Suit;
import be.isach.ultracosmetics.cosmetics.type.SuitType;
import be.isach.ultracosmetics.player.UltraPlayer;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class SuitRave
extends Suit
implements Updatable {
    private int[] colors = new int[]{255, 0, 0};
    private int tick = 0;
    private int updateInterval = SettingsManager.getConfig().getInt("Suits.Rave.Update-Delay-In-Creative", 1);

    public SuitRave(UltraPlayer owner, SuitType suitType, UltraCosmetics ultraCosmetics) {
        super(owner, suitType, ultraCosmetics);
    }

    @Override
    protected boolean isAsync() {
        return false;
    }

    @Override
    public void onEquip() {
        for (ArmorSlot slot : ArmorSlot.values()) {
            Suit part;
            if (slot == this.getArmorSlot() || !((part = this.getOwner().getCurrentSuit(slot)) instanceof SuitRave)) continue;
            this.tick = ((SuitRave)part).getTick();
            break;
        }
    }

    @Override
    public void onUpdate() {
        if (this.colors[0] == 255 && this.colors[1] < 255 && this.colors[2] == 0) {
            this.colors[1] = this.colors[1] + 15;
        }
        if (this.colors[1] == 255 && this.colors[0] > 0 && this.colors[2] == 0) {
            this.colors[0] = this.colors[0] - 15;
        }
        if (this.colors[1] == 255 && this.colors[2] < 255 && this.colors[0] == 0) {
            this.colors[2] = this.colors[2] + 15;
        }
        if (this.colors[2] == 255 && this.colors[1] > 0 && this.colors[0] == 0) {
            this.colors[1] = this.colors[1] - 15;
        }
        if (this.colors[2] == 255 && this.colors[0] < 255 && this.colors[1] == 0) {
            this.colors[0] = this.colors[0] + 15;
        }
        if (this.colors[0] == 255 && this.colors[2] > 0 && this.colors[1] == 0) {
            this.colors[2] = this.colors[2] - 15;
        }
        this.refresh();
    }

    private void refresh() {
        if (this.getPlayer().getGameMode() == GameMode.CREATIVE && ++this.tick < this.updateInterval) {
            return;
        }
        this.tick = 0;
        LeatherArmorMeta itemMeta = (LeatherArmorMeta)this.itemStack.getItemMeta();
        itemMeta.setColor(Color.fromRGB((int)this.colors[0], (int)this.colors[1], (int)this.colors[2]));
        this.itemStack.setItemMeta((ItemMeta)itemMeta);
        this.setArmorItem(this.itemStack);
    }

    public int getTick() {
        return this.tick;
    }
}

