/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.type;

import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.Cosmetic;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.particles.XParticle;

public class CosmeticParticleType<T extends Cosmetic<?>>
extends CosmeticType<T> {
    private final XParticle effect;
    private final int repeatDelay;
    private final double particleMultiplier;

    public CosmeticParticleType(Category category, String configName, int repeatDelay, XParticle effect, XMaterial material, Class<? extends T> clazz, boolean supportsParticleMultiplier) {
        super(category, configName, material, clazz);
        this.effect = effect;
        this.repeatDelay = repeatDelay;
        if (supportsParticleMultiplier) {
            String path = this.getCategory().getConfigPath() + "." + configName + ".Particle-Multiplier";
            if (!SettingsManager.getConfig().isDouble(path)) {
                this.particleMultiplier = 1.0;
                SettingsManager.getConfig().set(this.getCategory().getConfigPath() + "." + configName + ".Particle-Multiplier", (Object)1.0, "A multiplier applied to the number", "of XParticle displayed. 1.0 is 100%");
            } else {
                this.particleMultiplier = SettingsManager.getConfig().getDouble(path);
            }
        } else {
            this.particleMultiplier = 1.0;
        }
    }

    public XParticle getEffect() {
        return this.effect;
    }

    public int getRepeatDelay() {
        return this.repeatDelay;
    }

    public double getParticleMultiplier() {
        return this.particleMultiplier;
    }
}

