/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.type;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.CustomConfiguration;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.Cosmetic;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.type.DeathEffectType;
import be.isach.ultracosmetics.cosmetics.type.EmoteType;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.cosmetics.type.HatType;
import be.isach.ultracosmetics.cosmetics.type.MorphType;
import be.isach.ultracosmetics.cosmetics.type.MountType;
import be.isach.ultracosmetics.cosmetics.type.ParticleEffectType;
import be.isach.ultracosmetics.cosmetics.type.PetType;
import be.isach.ultracosmetics.cosmetics.type.ProjectileEffectType;
import be.isach.ultracosmetics.cosmetics.type.SuitCategory;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.SmartLogger;
import be.isach.ultracosmetics.version.ServerVersion;
import com.cryptomorin.xseries.XMaterial;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;

public abstract class CosmeticType<T extends Cosmetic<?>> {
    public static final boolean GENERATE_MISSING_MESSAGES = false;
    private static final Permission ALL_PERMISSION = new Permission("ultracosmetics.allcosmetics");
    private static final Map<String, Permission> registeredPermissions = new HashMap<String, Permission>();
    private static final Map<Category, List<CosmeticType<?>>> VALUES = new HashMap();
    private static final Map<Category, List<CosmeticType<?>>> ENABLED = new HashMap();
    private static final YamlConfiguration customConfig = new YamlConfiguration();
    private final String configName;
    private final List<String> description;
    private final Class<? extends T> clazz;
    private final Category category;
    private final XMaterial material;
    private Permission permission;

    public static void loadCustomCosmetics() {
        try {
            File configFile = new File(UltraCosmeticsData.get().getPlugin().getDataFolder(), "custom_cosmetics.yml");
            if (!configFile.exists()) {
                UltraCosmeticsData.get().getPlugin().saveResource("custom_cosmetics.yml", false);
            }
            customConfig.load(configFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            UltraCosmeticsData.get().getPlugin().getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Failed to load custom cosmetics, they will be ignored.");
            e.printStackTrace();
        }
    }

    protected static ConfigurationSection getCustomConfig(Category cat) {
        if (cat.isSuits()) {
            return customConfig.getConfigurationSection("Suits");
        }
        return customConfig.getConfigurationSection(cat.getConfigPath());
    }

    public static <V extends CosmeticType<?>> V valueOf(Category cat, String name) {
        for (CosmeticType<?> type : VALUES.get((Object)cat)) {
            if (!type.getConfigName().equalsIgnoreCase(name)) continue;
            return (V)type;
        }
        return null;
    }

    public static List<CosmeticType<?>> valuesOf(Category cat) {
        return VALUES.getOrDefault((Object)cat, new ArrayList());
    }

    public static List<CosmeticType<?>> enabledOf(Category cat) {
        return ENABLED.getOrDefault((Object)cat, new ArrayList());
    }

    public static void removeAllTypes() {
        VALUES.clear();
        ENABLED.clear();
        SuitCategory.values().clear();
    }

    public static void registerAll() {
        ServerVersion version = UltraCosmeticsData.get().getServerVersion();
        GadgetType.register(version);
        MountType.register(version);
        ParticleEffectType.register(version);
        PetType.register();
        HatType.register();
        SuitCategory.register();
        for (SuitCategory sc : SuitCategory.values()) {
            sc.initializeSuitParts();
        }
        MorphType.register();
        EmoteType.register();
        ProjectileEffectType.register(version);
        DeathEffectType.register();
        ALL_PERMISSION.recalculatePermissibles();
        MessageManager.save();
        VALUES.forEach((c, l) -> l.forEach(t -> t.setupConfig(SettingsManager.getConfig(), t.getConfigPath())));
        CosmeticType.updateEnabled();
    }

    public static void updateEnabled() {
        ENABLED.clear();
        VALUES.forEach((cat, types) -> types.forEach(type -> {
            if (type.isEnabled()) {
                ENABLED.computeIfAbsent((Category)((Object)cat), l -> new ArrayList()).add(type);
            }
        }));
    }

    public CosmeticType(Category category, String configName, XMaterial material, Class<? extends T> clazz) {
        this(category, configName, material, clazz, true);
    }

    public CosmeticType(Category category, String configName, XMaterial material, Class<? extends T> clazz, boolean registerPerm) {
        this.category = category;
        this.configName = configName;
        this.material = material;
        this.clazz = clazz;
        Object colors = MessageManager.getMiniMessage().deserialize(SettingsManager.getConfig().getString("Description-Style", ""));
        this.description = MessageManager.getLore(this.getCategory().getConfigPath() + "." + configName + ".Description", colors.style(), new TagResolver.Single[0]);
        if (registerPerm) {
            this.registerPermission();
        }
        VALUES.computeIfAbsent(category, l -> new ArrayList()).add(this);
        if (this.isEnabled()) {
            ENABLED.computeIfAbsent(category, l -> new ArrayList()).add(this);
        }
    }

    public T equip(UltraPlayer player, UltraCosmetics ultraCosmetics) {
        Cosmetic cosmetic = null;
        try {
            Class<?> selfClass = this.getClass();
            if (selfClass.isAnonymousClass()) {
                selfClass = selfClass.getSuperclass();
            }
            cosmetic = (Cosmetic)this.getClazz().getDeclaredConstructor(UltraPlayer.class, selfClass, UltraCosmetics.class).newInstance(new Object[]{player, this, ultraCosmetics});
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            return null;
        }
        cosmetic.equip();
        return (T)cosmetic;
    }

    public boolean isEnabled() {
        return SettingsManager.getConfig().getBoolean(this.category.getConfigPath() + "." + this.configName + ".Enabled");
    }

    public Component getName() {
        return MessageManager.getMessage(this.category.getConfigPath() + "." + this.configName + ".name", new TagResolver.Single[0]);
    }

    public String getConfigName() {
        return this.configName;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public Class<? extends T> getClazz() {
        return this.clazz;
    }

    public Category getCategory() {
        return this.category;
    }

    public XMaterial getMaterial() {
        return this.material;
    }

    public ItemStack getItemStack() {
        String skull = SettingsManager.getConfig().getString(this.category.getConfigPath() + "." + this.getConfigName() + ".Custom-Head");
        if (skull != null) {
            return ItemFactory.createSkull(skull, "");
        }
        return this.material.parseItem();
    }

    public String getConfigPath() {
        return this.getCategory().getConfigPath() + "." + this.getConfigName();
    }

    public List<String> getDescription() {
        return this.description;
    }

    public boolean showsDescription() {
        return SettingsManager.getConfig().getBoolean(this.category.getConfigPath() + "." + this.getConfigName() + ".Show-Description");
    }

    public boolean canBeFound() {
        return this.getChestWeight() > 0;
    }

    public int getChestWeight() {
        return SettingsManager.getConfig().getInt(this.category.getConfigPath() + "." + this.getConfigName() + ".Treasure-Chest-Weight");
    }

    public String toString() {
        return this.getConfigName().toUpperCase(Locale.ROOT);
    }

    protected void registerPermission() {
        this.permission = registeredPermissions.computeIfAbsent(this.category.getPermission() + "." + this.getPermissionSuffix(), s -> {
            Permission perm = new Permission(s);
            try {
                ALL_PERMISSION.getChildren().put(s, true);
                Bukkit.getPluginManager().addPermission(perm);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return perm;
        });
    }

    protected String getPermissionSuffix() {
        return this.getConfigName().toLowerCase(Locale.ROOT);
    }

    protected void setupConfig(CustomConfiguration config, String path) {
        if (PlayerAffectingCosmetic.class.isAssignableFrom(this.getClazz())) {
            config.addDefault(path + ".Affect-Players", (Object)true, "Should it affect players? (Velocity, etc.)");
        }
        config.addDefault(path + ".Enabled", true);
        config.addDefault(path + ".Show-Description", (Object)true, "Whether to show description when hovering in GUI");
        String findableKey = path + ".Can-Be-Found-In-Treasure-Chests";
        int weight = 1;
        if (config.isBoolean(findableKey)) {
            weight = config.getBoolean(findableKey) ? 1 : 0;
            config.set(findableKey, null);
        }
        config.addDefault(path + ".Treasure-Chest-Weight", (Object)weight, "The higher the weight, the better the chance of", "finding this cosmetic when this category is picked.", "Fractional values are not allowed.", "Set to 0 to disable finding in chests.");
        config.addDefault(path + ".Purchase-Price", (Object)500, "Price to buy individually in GUI", "Only works if No-Permission.Allow-Purchase is true and this setting > 0");
    }

    static {
        try {
            Bukkit.getPluginManager().addPermission(ALL_PERMISSION);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

