/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.economy;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.economy.EconomyHook;
import org.bukkit.entity.Player;
import su.nightexpress.coinsengine.api.CoinsEngineAPI;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.currency.CurrencyManager;

public class CoinsEngineHook
implements EconomyHook {
    private final Currency currency;

    public CoinsEngineHook(UltraCosmetics ultraCosmetics, String currencyName) {
        if (currencyName == null) {
            CurrencyManager cm = CoinsEngineAPI.getCurrencyManager();
            if (cm.getVaultCurrency().isPresent()) {
                this.currency = (Currency)cm.getVaultCurrency().get();
                return;
            }
            currencyName = ((Currency)cm.getCurrencies().iterator().next()).getName();
        }
        this.currency = CoinsEngineAPI.getCurrency((String)currencyName);
        if (this.currency == null) {
            throw new IllegalArgumentException("Couldn't find specified CoinsEngine currency '" + currencyName + "'");
        }
    }

    @Override
    public void withdraw(Player player, int amount, Runnable onSuccess, Runnable onFailure) {
        double balance = CoinsEngineAPI.getBalance((Player)player, (Currency)this.currency);
        if (balance < (double)amount) {
            onFailure.run();
            return;
        }
        CoinsEngineAPI.removeBalance((Player)player, (Currency)this.currency, (double)amount);
        onSuccess.run();
    }

    @Override
    public void deposit(Player player, int amount) {
        CoinsEngineAPI.addBalance((Player)player, (Currency)this.currency, (double)amount);
    }

    @Override
    public String getName() {
        return "CoinsEngine:" + this.currency.getName();
    }
}

