/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.economy;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.economy.EconomyHook;
import java.util.Iterator;
import org.bukkit.entity.Player;
import ru.soknight.peconomy.api.PEconomyAPI;
import ru.soknight.peconomy.configuration.CurrencyInstance;
import ru.soknight.peconomy.database.model.WalletModel;

public class PEconomyHook
implements EconomyHook {
    private final UltraCosmetics ultraCosmetics;
    private final PEconomyAPI api = PEconomyAPI.get();
    private final CurrencyInstance currency;

    public PEconomyHook(UltraCosmetics ultraCosmetics, String currencyName) {
        this.ultraCosmetics = ultraCosmetics;
        if (currencyName == null) {
            Iterator iter = this.api.getLoadedCurrencies().iterator();
            if (!iter.hasNext()) {
                throw new IllegalStateException("No currencies available from PEconomy");
            }
            this.currency = (CurrencyInstance)iter.next();
        } else {
            this.currency = this.api.getCurrencyByID(currencyName);
            if (this.currency == null) {
                throw new IllegalArgumentException("Couldn't find PEconomy currency '" + currencyName + "'");
            }
        }
    }

    @Override
    public void withdraw(Player player, int amount, Runnable onSuccess, Runnable onFailure) {
        this.ultraCosmetics.getScheduler().runAsync(outer -> {
            WalletModel wallet = this.api.getWallet(player.getName());
            if (wallet.hasAmount(this.currency.getId(), (float)amount)) {
                wallet.takeAmount(this.currency.getId(), (float)amount);
                this.api.updateWallet(wallet);
                this.ultraCosmetics.getScheduler().runNextTick(inner -> onSuccess.run());
            } else {
                this.ultraCosmetics.getScheduler().runNextTick(inner -> onFailure.run());
            }
        });
    }

    @Override
    public void deposit(Player player, int amount) {
        this.ultraCosmetics.getScheduler().runAsync(task -> this.api.updateWallet(this.api.addAmount(player.getName(), this.currency.getId(), (float)amount)));
    }

    @Override
    public String getName() {
        return "PEconomy:" + this.currency.getId();
    }
}

