/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.economy;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.economy.EconomyHook;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import me.lokka30.treasury.api.common.Cause;
import me.lokka30.treasury.api.common.NamespacedKey;
import me.lokka30.treasury.api.common.service.Service;
import me.lokka30.treasury.api.common.service.ServiceRegistry;
import me.lokka30.treasury.api.economy.EconomyProvider;
import me.lokka30.treasury.api.economy.currency.Currency;
import org.bukkit.entity.Player;

public class TreasuryHook
implements EconomyHook {
    private final UltraCosmetics ultraCosmetics;
    private final EconomyProvider economy;
    private final Cause<NamespacedKey> cause = Cause.plugin((NamespacedKey)NamespacedKey.of((String)"UltraCosmetics", (String)"TreasuryHook"));
    private final Currency currency;

    public TreasuryHook(UltraCosmetics ultraCosmetics, String currencyName) {
        this.ultraCosmetics = ultraCosmetics;
        Optional optProvider = ServiceRegistry.INSTANCE.serviceFor(EconomyProvider.class);
        if (!optProvider.isPresent()) {
            throw new IllegalStateException("Could not find provider for Treasury economy.");
        }
        this.economy = (EconomyProvider)((Service)optProvider.get()).get();
        if (currencyName == null) {
            this.currency = this.economy.getPrimaryCurrency();
        } else {
            Optional optCurrency = this.economy.findCurrency(currencyName);
            if (!optCurrency.isPresent()) {
                throw new IllegalArgumentException("Couldn't find specified Treasury currency '" + currencyName + "'");
            }
            this.currency = (Currency)optCurrency.get();
        }
    }

    private Runnable mainThread(Runnable runnable) {
        return () -> this.ultraCosmetics.getScheduler().runNextTick(task -> runnable.run());
    }

    @Override
    public void withdraw(Player player, int intAmount, Runnable onSuccess, Runnable onFailure) {
        BigDecimal amount = new BigDecimal(intAmount);
        ((CompletableFuture)((CompletableFuture)this.economy.accountAccessor().player().withUniqueId(player.getUniqueId()).get().thenCompose(account -> account.withdrawBalance(amount, this.cause, this.currency))).thenRun(this.mainThread(onSuccess))).exceptionally(ex -> {
            this.mainThread(onFailure).run();
            return null;
        });
    }

    @Override
    public void deposit(Player player, int intAmount) {
        BigDecimal amount = new BigDecimal(intAmount);
        this.economy.accountAccessor().player().withUniqueId(player.getUniqueId()).get().thenCompose(account -> account.depositBalance(amount, this.cause, this.currency));
    }

    @Override
    public String getName() {
        return "Treasury:" + this.currency.getIdentifier();
    }
}

