/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.listeners;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.menu.MenuItemHandler;
import be.isach.ultracosmetics.util.UnmovableItemProvider;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;

public class UnmovableItemListener
implements Listener {
    private final Set<UnmovableItemProvider> providers = ConcurrentHashMap.newKeySet();

    public UnmovableItemListener(UltraCosmetics ultraCosmetics) {
        if (SettingsManager.getConfig().getBoolean("Menu-Item.Enabled")) {
            this.providers.add(new MenuItemHandler(ultraCosmetics));
        }
    }

    public void addProvider(UnmovableItemProvider provider) {
        this.providers.add(provider);
    }

    public void removeProvider(UnmovableItemProvider provider) {
        this.providers.remove(provider);
    }

    public void forEachProvider(Player player, Consumer<UnmovableItemProvider> func) {
        for (UnmovableItemProvider provider : this.providers) {
            if (provider.getPlayer() != null && provider.getPlayer() != player) continue;
            func.accept(provider);
        }
    }

    public void forEachProviderWithItem(Player player, ItemStack stack, Consumer<UnmovableItemProvider> func) {
        this.forEachProvider(player, p -> {
            if (p.itemMatches(stack)) {
                func.accept((UnmovableItemProvider)p);
            }
        });
    }

    public boolean isImmovable(Player player, ItemStack itemStack) {
        for (UnmovableItemProvider provider : this.providers) {
            if (provider.getPlayer() != null && provider.getPlayer() != player || !provider.itemMatches(itemStack)) continue;
            return true;
        }
        return false;
    }

    private boolean slotCheck(UnmovableItemProvider provider, int slot, Player player) {
        if (provider.getSlot() != slot) {
            provider.moveItem(slot, player);
            return false;
        }
        return true;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onItemDrop(PlayerDropItemEvent event) {
        this.forEachProviderWithItem(event.getPlayer(), event.getItemDrop().getItemStack(), p -> {
            if (this.slotCheck((UnmovableItemProvider)p, event.getPlayer().getInventory().getHeldItemSlot(), event.getPlayer())) {
                p.handleDrop(event);
            }
        });
    }

    @EventHandler
    public void cancelMove(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        this.forEachProvider(player, p -> {
            if (p.itemMatches(event.getCurrentItem())) {
                this.slotCheck((UnmovableItemProvider)p, event.getSlot(), player);
            } else if (event.getClick() == ClickType.NUMBER_KEY && p.itemMatches(player.getInventory().getItem(event.getHotbarButton()))) {
                this.slotCheck((UnmovableItemProvider)p, event.getHotbarButton(), player);
            } else {
                return;
            }
            event.setCancelled(true);
            player.updateInventory();
            p.handleClick(player);
        });
    }

    @EventHandler
    public void cancelMove(InventoryCreativeEvent event) {
        Player player = (Player)event.getWhoClicked();
        this.forEachProvider(player, p -> {
            if (p.itemMatches(event.getCurrentItem())) {
                this.slotCheck((UnmovableItemProvider)p, event.getSlot(), player);
            } else if (!p.itemMatches(event.getCursor())) {
                return;
            }
            event.setCancelled(true);
            player.closeInventory();
            p.handleClick(player);
        });
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (event.getRightClicked() instanceof Player) {
            return;
        }
        this.forEachProviderWithItem(event.getPlayer(), event.getPlayer().getInventory().getItemInMainHand(), p -> {
            this.slotCheck((UnmovableItemProvider)p, event.getPlayer().getInventory().getHeldItemSlot(), event.getPlayer());
            event.setCancelled(true);
        });
    }

    @EventHandler
    public void onPlayerInteractArmorStand(PlayerArmorStandManipulateEvent event) {
        this.onPlayerInteractEntity((PlayerInteractEntityEvent)event);
    }

    @EventHandler
    public void onClick(PlayerInteractEvent event) {
        if (event.getAction() == Action.PHYSICAL) {
            return;
        }
        this.forEachProviderWithItem(event.getPlayer(), event.getItem(), p -> {
            if (this.slotCheck((UnmovableItemProvider)p, event.getPlayer().getInventory().getHeldItemSlot(), event.getPlayer())) {
                p.handleInteract(event);
            }
        });
    }

    @EventHandler
    public void onPlayerSwapoffHand(PlayerSwapHandItemsEvent event) {
        this.forEachProvider(event.getPlayer(), p -> {
            if (p.itemMatches(event.getMainHandItem()) || p.itemMatches(event.getOffHandItem())) {
                event.setCancelled(true);
            }
        });
    }
}

