/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.player.UltraPlayerManager;
import be.isach.ultracosmetics.util.InventoryViewHelper;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.UnmovableItemProvider;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class MenuItemHandler
implements UnmovableItemProvider {
    private final UltraCosmetics ultraCosmetics;
    private final UltraPlayerManager pm;
    private final int slot = SettingsManager.getConfig().getInt("Menu-Item.Slot");
    private final boolean menuOnClick = SettingsManager.getConfig().getBoolean("Menu-Item.Open-Menu-On-Inventory-Click");
    private final ItemStack menuItem = ItemFactory.getMenuItem();

    public MenuItemHandler(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
        this.pm = ultraCosmetics.getPlayerManager();
    }

    @Override
    public Player getPlayer() {
        return null;
    }

    @Override
    public boolean itemMatches(ItemStack stack) {
        return this.menuItem.isSimilar(stack);
    }

    @Override
    public void handleDrop(PlayerDropItemEvent event) {
        event.setCancelled(true);
    }

    @Override
    public int getSlot() {
        return this.slot;
    }

    @Override
    public void moveItem(int slot, Player player) {
        PlayerInventory inv = player.getInventory();
        ItemStack current = inv.getItem(this.slot);
        if (current != null && current.getType() != Material.AIR) {
            inv.setItem(slot, current);
            inv.setItem(this.slot, null);
        }
        this.pm.getUltraPlayer(player).giveMenuItem();
    }

    @Override
    public void handleInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        UltraPlayer ultraPlayer = this.pm.getUltraPlayer(event.getPlayer());
        if (ultraPlayer == null) {
            return;
        }
        InventoryType t = InventoryViewHelper.getType(event.getPlayer());
        if (t != InventoryType.CRAFTING && t != InventoryType.CREATIVE) {
            return;
        }
        if (ultraPlayer.getCurrentTreasureChest() != null) {
            event.setCancelled(true);
            return;
        }
        event.setCancelled(true);
        this.ultraCosmetics.getMenus().openMainMenu(ultraPlayer);
    }

    @Override
    public void handleClick(Player player) {
        if (this.menuOnClick) {
            this.ultraCosmetics.getScheduler().runAtEntityLater((Entity)player, () -> this.ultraCosmetics.getMenus().openMainMenu(this.pm.getUltraPlayer(player)), 1L);
        }
    }
}

