/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu.buttons;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.cosmetics.type.EmoteType;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.cosmetics.type.MorphType;
import be.isach.ultracosmetics.cosmetics.type.PetType;
import be.isach.ultracosmetics.menu.Button;
import be.isach.ultracosmetics.menu.ClickData;
import be.isach.ultracosmetics.menu.MenuPurchase;
import be.isach.ultracosmetics.menu.MenuPurchaseFactory;
import be.isach.ultracosmetics.menu.PurchaseData;
import be.isach.ultracosmetics.menu.buttons.CosmeticNoPermissionButton;
import be.isach.ultracosmetics.menu.buttons.togglecosmetic.ToggleCosmeticButton;
import be.isach.ultracosmetics.menu.buttons.togglecosmetic.ToggleEmoteCosmeticButton;
import be.isach.ultracosmetics.menu.buttons.togglecosmetic.ToggleGadgetCosmeticButton;
import be.isach.ultracosmetics.menu.buttons.togglecosmetic.ToggleMorphCosmeticButton;
import be.isach.ultracosmetics.menu.buttons.togglecosmetic.TogglePetCosmeticButton;
import be.isach.ultracosmetics.permissions.PermissionManager;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.TextUtil;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class CosmeticButton
implements Button {
    protected final UltraCosmetics ultraCosmetics;
    protected final PermissionManager pm;
    protected final CosmeticType<?> cosmeticType;
    private final int price;
    private final boolean ignoreTooltip;
    private final boolean allowPurchase = SettingsManager.getConfig().getBoolean("No-Permission.Allow-Purchase");
    private final Component noPermissionMessage = MessageManager.getMessage("No-Permission", new TagResolver.Single[0]);
    private ItemStack stack = null;

    public static CosmeticButton fromType(CosmeticType<?> cosmeticType, UltraPlayer ultraPlayer, UltraCosmetics ultraCosmetics) {
        if (SettingsManager.getConfig().getBoolean("No-Permission.Custom-Item.enabled") && !ultraPlayer.canEquip(cosmeticType)) {
            return new CosmeticNoPermissionButton(ultraCosmetics, cosmeticType);
        }
        switch (cosmeticType.getCategory()) {
            case PETS: {
                return new TogglePetCosmeticButton(ultraCosmetics, (PetType)cosmeticType);
            }
            case GADGETS: {
                return new ToggleGadgetCosmeticButton(ultraCosmetics, (GadgetType)cosmeticType);
            }
            case MORPHS: {
                return new ToggleMorphCosmeticButton(ultraCosmetics, (MorphType)cosmeticType);
            }
            case EMOTES: {
                return new ToggleEmoteCosmeticButton(ultraCosmetics, (EmoteType)cosmeticType);
            }
        }
        return new ToggleCosmeticButton(ultraCosmetics, cosmeticType);
    }

    public CosmeticButton(UltraCosmetics ultraCosmetics, CosmeticType<?> cosmeticType, boolean ignoreTooltip) {
        this.ultraCosmetics = ultraCosmetics;
        this.pm = ultraCosmetics.getPermissionManager();
        this.cosmeticType = cosmeticType;
        this.price = SettingsManager.getConfig().getInt(cosmeticType.getConfigPath() + ".Purchase-Price");
        this.ignoreTooltip = ignoreTooltip;
    }

    @Override
    public void onClick(ClickData clickData) {
        boolean success = this.handleClick(clickData);
        if (success && UltraCosmeticsData.get().shouldCloseAfterSelect()) {
            clickData.getClicker().getBukkitPlayer().closeInventory();
        }
    }

    protected ItemStack generateDisplayItem(UltraPlayer ultraPlayer) {
        ItemStack stack = this.getBaseItem(ultraPlayer);
        this.addPurchaseLore(stack, ultraPlayer);
        return stack;
    }

    @Override
    public ItemStack getDisplayItem(UltraPlayer ultraPlayer) {
        if (this.stack == null) {
            this.stack = this.generateDisplayItem(ultraPlayer);
        }
        return this.stack;
    }

    protected abstract ItemStack getBaseItem(UltraPlayer var1);

    protected boolean handleClick(ClickData data) {
        UltraPlayer ultraPlayer = data.getClicker();
        ItemStack clicked = data.getClicked();
        if (data.getClick().isRightClick() && ultraPlayer.canEquip(this.cosmeticType)) {
            this.handleRightClick(data);
            return false;
        }
        if (this.ignoreTooltip || this.startsWithColorless(clicked.getItemMeta().getDisplayName(), this.cosmeticType.getCategory().getActivateTooltip())) {
            if (ultraPlayer.canEquip(this.cosmeticType)) {
                this.cosmeticType.equip(ultraPlayer, this.ultraCosmetics);
                if (ultraPlayer.hasCosmetic(this.cosmeticType.getCategory())) {
                    return this.handleActivate(data);
                }
                return true;
            }
            if (!this.allowPurchase || this.price <= 0) {
                ultraPlayer.sendMessage(this.noPermissionMessage);
                return true;
            }
            String itemName = MessageManager.getLegacyMessage("Buy-Cosmetic-Description", Placeholder.unparsed("price", TextUtil.formatNumber(this.ultraCosmetics.getEconomyHandler().calculateDiscountPrice(ultraPlayer.getBukkitPlayer(), this.price))), Placeholder.component("gadgetname", this.cosmeticType.getName()));
            ItemStack display = ItemFactory.rename(this.cosmeticType.getItemStack(), itemName, new String[0]);
            PurchaseData pd = new PurchaseData();
            pd.setBasePrice(this.price);
            pd.setShowcaseItem(display);
            pd.setOnPurchase(() -> {
                this.pm.setPermission(ultraPlayer, this.cosmeticType);
                this.ultraCosmetics.getScheduler().runAtEntityLater((Entity)ultraPlayer.getBukkitPlayer(), () -> {
                    this.cosmeticType.equip(ultraPlayer, this.ultraCosmetics);
                    data.getMenu().refresh(ultraPlayer);
                }, 5L);
            });
            pd.setOnCancel(() -> data.getMenu().refresh(ultraPlayer));
            Component title = MessageManager.getMessage("Menu.Purchase-Cosmetic.Title", Placeholder.component("cosmetic", this.cosmeticType.getName()));
            MenuPurchaseFactory mpFactory = this.ultraCosmetics.getMenus().getMenuPurchaseFactory();
            MenuPurchase mp = mpFactory.createPurchaseMenu(this.ultraCosmetics, title, pd);
            ultraPlayer.getBukkitPlayer().openInventory(mp.getInventory(ultraPlayer));
            return false;
        }
        if (this.startsWithColorless(clicked.getItemMeta().getDisplayName(), this.cosmeticType.getCategory().getDeactivateTooltip())) {
            ultraPlayer.removeCosmetic(this.cosmeticType.getCategory());
            if (!UltraCosmeticsData.get().shouldCloseAfterSelect()) {
                data.getMenu().refresh(ultraPlayer);
            }
        }
        return true;
    }

    private void addPurchaseLore(ItemStack stack, UltraPlayer player) {
        if (this.price > 0 && !player.canEquip(this.cosmeticType) && this.allowPurchase) {
            ItemMeta meta = stack.getItemMeta();
            List lore = meta.getLore();
            lore.add("");
            int discountPrice = this.ultraCosmetics.getEconomyHandler().calculateDiscountPrice(player.getBukkitPlayer(), this.price);
            lore.add(MessageManager.getLegacyMessage("Click-To-Purchase", Placeholder.unparsed("price", String.valueOf(discountPrice))));
            meta.setLore(lore);
            stack.setItemMeta(meta);
        }
    }

    protected boolean handleActivate(ClickData clickData) {
        if (!UltraCosmeticsData.get().shouldCloseAfterSelect()) {
            clickData.getMenu().refresh(clickData.getClicker());
        }
        return true;
    }

    protected void handleRightClick(ClickData clickData) {
    }

    protected boolean startsWithColorless(String a, Component b) {
        return ChatColor.stripColor((String)a).startsWith(PlainTextComponentSerializer.plainText().serialize(b));
    }
}

