/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu.buttons;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.menu.ClickData;
import be.isach.ultracosmetics.menu.buttons.TreasureButton;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.ItemFactory;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.XSound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class KeysButton
extends TreasureButton {
    private final String itemName = MessageManager.getLegacyMessage("Treasure-Keys", new TagResolver.Single[0]);
    private final UltraCosmetics ultraCosmetics;
    private final XSound.SoundPlayer noKeysSound;

    public KeysButton(UltraCosmetics ultraCosmetics) {
        super(ultraCosmetics);
        this.ultraCosmetics = ultraCosmetics;
        this.noKeysSound = XSound.BLOCK_ANVIL_LAND.record().withVolume(0.2f).withPitch(1.2f).soundPlayer();
    }

    @Override
    public ItemStack getDisplayItem(UltraPlayer ultraPlayer) {
        Component yourKeysMessage = MessageManager.getMessage("Your-Keys", Placeholder.unparsed("keys", String.valueOf(ultraPlayer.getKeys())));
        XMaterial keyItem = XMaterial.TRIPWIRE_HOOK;
        if (XMaterial.TRIAL_KEY.isSupported() && XMaterial.TRIAL_KEY.get().isEnabledByFeature(ultraPlayer.getBukkitPlayer().getWorld())) {
            keyItem = XMaterial.TRIAL_KEY;
        }
        return ItemFactory.create(keyItem, this.itemName, "", MessageManager.toLegacy(yourKeysMessage), this.buyKeyMessage);
    }

    @Override
    public void onClick(ClickData clickData) {
        UltraPlayer clicker = clickData.getClicker();
        if (!this.canBuyKeys) {
            this.noKeysSound.forPlayers(new Player[]{clicker.getBukkitPlayer()});
            return;
        }
        clicker.getBukkitPlayer().closeInventory();
        this.ultraCosmetics.getMenus().openKeyPurchaseMenu(clicker);
    }
}

