/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu.buttons;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.SuitCategory;
import be.isach.ultracosmetics.menu.Button;
import be.isach.ultracosmetics.menu.ClickData;
import be.isach.ultracosmetics.menu.Menus;
import be.isach.ultracosmetics.permissions.PermissionManager;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.LazyTag;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permission;

public class OpenCosmeticMenuButton
implements Button {
    private final UltraCosmetics ultraCosmetics;
    protected final Category category;
    protected final PermissionManager pm;
    protected final Menus menus;
    protected final ItemStack baseStack;
    protected final Permission openPermission;

    public OpenCosmeticMenuButton(UltraCosmetics ultraCosmetics, Category category) {
        this.ultraCosmetics = ultraCosmetics;
        this.category = category;
        this.baseStack = category.getItemStack();
        this.pm = ultraCosmetics.getPermissionManager();
        this.menus = ultraCosmetics.getMenus();
        this.openPermission = this.menus.getCategoryMenu(category).getPermission();
    }

    @Override
    public ItemStack getDisplayItem(UltraPlayer ultraPlayer) {
        ItemStack stack = this.baseStack.clone();
        ArrayList<String> loreList = new ArrayList<String>();
        loreList.add("");
        Player player = ultraPlayer.getBukkitPlayer();
        if (!this.category.isEnabled()) {
            loreList.add(MessageManager.getLegacyMessage("Menu.Disabled-Button", new TagResolver.Single[0]));
        } else if (!player.hasPermission(this.openPermission)) {
            loreList.add(MessageManager.getLegacyMessage("No-Permission", new TagResolver.Single[0]));
        } else {
            String lore = MessageManager.getLegacyMessage("Menu." + this.category.getConfigPath() + ".Button.Lore", TagResolver.resolver("unlocked", new LazyTag(() -> Component.text(this.calculateUnlocked(player)))));
            loreList.addAll(Arrays.asList(lore.split("\n")));
        }
        ItemMeta meta = stack.getItemMeta();
        meta.setLore(loreList);
        stack.setItemMeta(meta);
        return stack;
    }

    protected String calculateUnlocked(Player player) {
        int total;
        int unlocked = 0;
        if (this.category.isSuits()) {
            for (Category cat : Category.enabled()) {
                if (!cat.isSuits()) continue;
                unlocked += this.pm.getEnabledUnlocked(player, cat).size();
            }
            total = SuitCategory.enabled().size() * 4;
        } else {
            unlocked = this.pm.getEnabledUnlocked(player, this.category).size();
            total = this.category.getEnabled().size();
        }
        return unlocked + "/" + total;
    }

    @Override
    public void onClick(ClickData clickData) {
        if (this.category.isEnabled() && clickData.getClicker().getBukkitPlayer().hasPermission(this.openPermission)) {
            this.menus.getCategoryMenu(this.category).open(clickData.getClicker());
        }
    }
}

