/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.menu.menus;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.SuitCategory;
import be.isach.ultracosmetics.cosmetics.type.SuitType;
import be.isach.ultracosmetics.menu.CosmeticMenu;
import be.isach.ultracosmetics.menu.buttons.EquipWholeSuitButton;
import be.isach.ultracosmetics.player.UltraPlayer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.Inventory;

public final class MenuSuits
extends CosmeticMenu<SuitType> {
    private static final int[] SLOTS = new int[]{10, 11, 12, 13, 14, 15, 16};

    public MenuSuits(UltraCosmetics ultraCosmetics) {
        super(ultraCosmetics, Category.SUITS_HELMET);
    }

    @Override
    protected int getSize() {
        return 54;
    }

    @Override
    protected void putItems(Inventory inventory, UltraPlayer player, int page) {
        int from = (page - 1) * this.getItemsPerPage();
        int to = page * this.getItemsPerPage();
        List<SuitCategory> enabled = SuitCategory.enabled();
        for (int i = from; i < to && i < enabled.size(); ++i) {
            SuitCategory cat = enabled.get(i);
            if (this.hideNoPermissionItems) {
                if (!cat.getPieces().stream().anyMatch(player::canEquip)) continue;
            }
            this.putItem(inventory, SLOTS[i % this.getItemsPerPage()] - 9, new EquipWholeSuitButton(cat, this.ultraCosmetics), player);
        }
    }

    @Override
    protected Map<Integer, SuitType> getSlots(int page, UltraPlayer player) {
        int from = (page - 1) * this.getItemsPerPage();
        int to = page * this.getItemsPerPage();
        HashMap<Integer, SuitType> slots = new HashMap<Integer, SuitType>();
        List<SuitCategory> enabled = SuitCategory.enabled();
        for (int i = from; i < to && i < enabled.size(); ++i) {
            SuitCategory cat = enabled.get(i);
            int row = 0;
            for (SuitType type : cat.getPieces()) {
                slots.put(SLOTS[i % this.getItemsPerPage()] + row++ * 9, type);
            }
        }
        return slots;
    }

    @Override
    protected int getItemsPerPage() {
        return 7;
    }

    @Override
    protected int getMaxPages(UltraPlayer player) {
        int i = 0;
        for (SuitCategory cat : SuitCategory.enabled()) {
            if (this.shouldHideItem(player, cat.getHelmet()) && this.shouldHideItem(player, cat.getChestplate()) && this.shouldHideItem(player, cat.getLeggings()) && this.shouldHideItem(player, cat.getBoots())) continue;
            ++i;
        }
        return Math.max(1, (i - 1) / this.getItemsPerPage() + 1);
    }

    @Override
    protected boolean hasUnlockable(UltraPlayer player) {
        for (SuitCategory cat : SuitCategory.enabled()) {
            if (player.canEquip(cat.getHelmet()) && player.canEquip(cat.getChestplate()) && player.canEquip(cat.getLeggings()) && player.canEquip(cat.getBoots())) continue;
            return true;
        }
        return false;
    }
}

