/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.mysql;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;

public class HikariHook {
    private final HikariDataSource dataSource;

    public HikariHook(String hostname, String port, String database, String username, String password) {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl("jdbc:mysql://" + hostname + ":" + port + "/" + database);
        config.setUsername(username);
        config.setPassword(password);
        config.addDataSourceProperty("prepStmtCacheSize", (Object)250);
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)2048);
        config.addDataSourceProperty("cachePrepStmts", (Object)true);
        config.addDataSourceProperty("useServerPrepStmts", (Object)true);
        config.addDataSourceProperty("characterEncoding", (Object)"utf8");
        config.addDataSourceProperty("useUnicode", (Object)true);
        this.dataSource = new HikariDataSource(config);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void close() {
        this.dataSource.close();
    }
}

