/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.mysql;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.mysql.HikariHook;
import be.isach.ultracosmetics.mysql.tables.AmmoTable;
import be.isach.ultracosmetics.mysql.tables.CosmeticTable;
import be.isach.ultracosmetics.mysql.tables.EquippedTable;
import be.isach.ultracosmetics.mysql.tables.PetNameTable;
import be.isach.ultracosmetics.mysql.tables.PlayerDataTable;
import be.isach.ultracosmetics.mysql.tables.Table;
import be.isach.ultracosmetics.mysql.tables.UnlockedTable;
import be.isach.ultracosmetics.util.SmartLogger;
import com.zaxxer.hikari.pool.HikariPool;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.bukkit.configuration.ConfigurationSection;

public class MySqlConnectionManager {
    public static final int MAX_NAME_SIZE = 256;
    private final UltraCosmetics ultraCosmetics;
    private CosmeticTable cosTable;
    private PlayerDataTable playerData;
    private AmmoTable ammoTable;
    private PetNameTable petNames;
    private EquippedTable equippedTable;
    private UnlockedTable unlockedTable;
    private final HikariHook hikariHook;
    private final DataSource dataSource;
    private final boolean debug;
    private boolean success = true;

    public MySqlConnectionManager(UltraCosmetics ultraCosmetics) {
        HikariHook hook;
        this.ultraCosmetics = ultraCosmetics;
        ConfigurationSection section = SettingsManager.getConfig().getConfigurationSection("MySQL");
        this.debug = section.getBoolean("debug", false);
        String hostname = section.getString("hostname");
        String port = section.getString("port");
        String database = section.getString("database");
        String username = section.getString("username");
        String password = section.getString("password");
        try {
            hook = new HikariHook(hostname, port, database, username, password);
        }
        catch (HikariPool.PoolInitializationException e) {
            this.hikariHook = null;
            this.dataSource = null;
            this.reportFailure(e);
            return;
        }
        this.hikariHook = hook;
        this.dataSource = this.hikariHook.getDataSource();
        this.playerData = new PlayerDataTable(this.dataSource, section.getString("player-data-table"));
        this.cosTable = new CosmeticTable(this.dataSource, section.getString("cosmetics-table"));
        if (UltraCosmeticsData.get().isAmmoEnabled()) {
            this.ammoTable = new AmmoTable(this.dataSource, section.getString("ammo-table"), this.playerData, this.cosTable);
        }
        if (SettingsManager.getConfig().getBoolean("Pets-Rename.Enabled")) {
            this.petNames = new PetNameTable(this.dataSource, section.getString("pet-names-table"), this.playerData, this.cosTable);
        }
        if (UltraCosmeticsData.get().areCosmeticsProfilesEnabled()) {
            this.equippedTable = new EquippedTable(this.dataSource, section.getString("equipped-cosmetics-table"), this.playerData, this.cosTable);
        }
        if (SettingsManager.getConfig().getString("TreasureChests.Permission-Add-Command").isEmpty()) {
            this.unlockedTable = new UnlockedTable(this.dataSource, section.getString("unlocked-cosmetics-table"), this.playerData, this.cosTable);
        }
    }

    public void start() {
        try (Connection conn = this.dataSource.getConnection();){
            this.create(conn, this.playerData);
            this.create(conn, this.cosTable);
            this.create(conn, this.unlockedTable);
            this.create(conn, this.ammoTable);
            this.create(conn, this.petNames);
            this.create(conn, this.equippedTable);
        }
        catch (SQLException e) {
            this.reportFailure(e);
        }
    }

    private void create(Connection conn, Table table) throws SQLException {
        if (table == null) {
            return;
        }
        table.setupTableInfo();
        String statement = table.getCreateTableStatement();
        if (this.debug) {
            this.ultraCosmetics.getSmartLogger().write("Executing create table: " + statement);
        }
        conn.createStatement().execute(statement);
        table.loadBaseData();
    }

    private void reportFailure(Throwable e) {
        this.success = false;
        UltraCosmeticsData.get().setFileStorage(true);
        SmartLogger log = this.ultraCosmetics.getSmartLogger();
        log.write(SmartLogger.LogLevel.ERROR, "Could not connect to MySQL server!");
        log.write(SmartLogger.LogLevel.ERROR, "Error:");
        e.printStackTrace();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean success() {
        return this.success;
    }

    public void shutdown() {
        this.hikariHook.close();
    }

    public CosmeticTable getCosTable() {
        return this.cosTable;
    }

    public PlayerDataTable getPlayerData() {
        return this.playerData;
    }

    public AmmoTable getAmmoTable() {
        return this.ammoTable;
    }

    public PetNameTable getPetNames() {
        return this.petNames;
    }

    public EquippedTable getEquippedTable() {
        return this.equippedTable;
    }

    public UnlockedTable getUnlockedTable() {
        return this.unlockedTable;
    }
}

