/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.mysql;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.cosmetics.type.PetType;
import be.isach.ultracosmetics.mysql.MySqlConnectionManager;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.player.profile.CosmeticsProfile;
import be.isach.ultracosmetics.player.profile.ProfileKey;
import be.isach.ultracosmetics.shaded.tcoded.folialib.wrapper.task.WrappedTask;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SqlCache
extends CosmeticsProfile {
    private final MySqlConnectionManager sql;
    private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();
    private volatile WrappedTask updateTask = null;

    public SqlCache(UltraPlayer ultraPlayer, UltraCosmetics ultraCosmetics) {
        super(ultraPlayer, ultraCosmetics);
        this.sql = ultraCosmetics.getMySqlConnectionManager();
    }

    @Override
    public void load() {
        this.data.loadFromSQL();
    }

    @Override
    public void save() {
    }

    @Override
    public void setEnabledCosmetic(Category cat, CosmeticType<?> type) {
        if (this.data.getEnabledCosmetics().get((Object)cat) == type) {
            return;
        }
        super.setEnabledCosmetic(cat, type);
        if (this.sql.getEquippedTable() == null) {
            return;
        }
        if (type == null) {
            this.queueUpdate(() -> this.sql.getEquippedTable().unsetEquipped(this.uuid, cat));
        } else {
            this.queueUpdate(() -> this.sql.getEquippedTable().setEquipped(this.uuid, type));
        }
    }

    @Override
    public void clearAllEquipped() {
        super.clearAllEquipped();
        if (this.sql.getEquippedTable() == null) {
            return;
        }
        this.queueUpdate(() -> this.sql.getEquippedTable().clearAllEquipped(this.uuid));
    }

    @Override
    public void setAmmo(GadgetType type, int amount) {
        super.setAmmo(type, amount);
        if (this.sql.getAmmoTable() == null) {
            return;
        }
        this.queueUpdate(() -> this.sql.getAmmoTable().setAmmo(this.uuid, type, amount));
    }

    @Override
    public void setPetName(PetType type, String name) {
        super.setPetName(type, name);
        if (this.sql.getPetNames() == null) {
            return;
        }
        this.queueUpdate(() -> this.sql.getPetNames().setPetName(this.uuid, type, name));
    }

    @Override
    public void setKeys(int amount) {
        super.setKeys(amount);
        this.queueUpdate(() -> this.sql.getPlayerData().setKeys(this.uuid, amount));
    }

    @Override
    public void setGadgetsEnabled(boolean gadgetsEnabled) {
        if (gadgetsEnabled == this.hasGadgetsEnabled()) {
            return;
        }
        super.setGadgetsEnabled(gadgetsEnabled);
        this.queueUpdate(() -> this.sql.getPlayerData().setSetting(this.uuid, ProfileKey.GADGETS_ENABLED, gadgetsEnabled));
    }

    @Override
    public void setSeeSelfMorph(boolean seeSelfMorph) {
        super.setSeeSelfMorph(seeSelfMorph);
        this.queueUpdate(() -> this.sql.getPlayerData().setSetting(this.uuid, ProfileKey.MORPH_VIEW, seeSelfMorph));
    }

    @Override
    public void setTreasureNotifications(boolean treasureNotifications) {
        super.setTreasureNotifications(treasureNotifications);
        this.queueUpdate(() -> this.sql.getPlayerData().setSetting(this.uuid, ProfileKey.TREASURE_NOTIFICATION, treasureNotifications));
    }

    @Override
    public void setFilterByOwned(boolean filterByOwned) {
        super.setFilterByOwned(filterByOwned);
        this.queueUpdate(() -> this.sql.getPlayerData().setSetting(this.uuid, ProfileKey.FILTER_OWNED, filterByOwned));
    }

    @Override
    public void setUnlocked(Set<CosmeticType<?>> types) {
        super.setUnlocked(types);
        if (this.sql.getUnlockedTable() == null) {
            return;
        }
        this.queueUpdate(() -> this.sql.getUnlockedTable().setUnlocked(this.uuid, types));
    }

    @Override
    public void setLocked(Set<CosmeticType<?>> types) {
        super.setLocked(types);
        if (this.sql.getUnlockedTable() == null) {
            return;
        }
        this.queueUpdate(() -> this.sql.getUnlockedTable().unsetUnlocked(this.uuid, types));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueUpdate(Runnable update) {
        Queue<Runnable> queue = this.queue;
        synchronized (queue) {
            this.queue.add(update);
            if (this.updateTask == null) {
                this.updateTask = this.ultraCosmetics.getScheduler().runLaterAsync(() -> {
                    Queue<Runnable> queue = this.queue;
                    synchronized (queue) {
                        while (!this.queue.isEmpty()) {
                            this.queue.poll().run();
                        }
                        this.updateTask = null;
                    }
                }, 1L);
            }
        }
    }
}

