/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.mysql.tables;

import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.mysql.column.Column;
import be.isach.ultracosmetics.mysql.column.ForeignKeyConstraint;
import be.isach.ultracosmetics.mysql.column.UUIDColumn;
import be.isach.ultracosmetics.mysql.column.UniqueConstraint;
import be.isach.ultracosmetics.mysql.column.VirtualUUIDColumn;
import be.isach.ultracosmetics.mysql.query.InnerJoin;
import be.isach.ultracosmetics.mysql.query.InsertQuery;
import be.isach.ultracosmetics.mysql.query.InsertValue;
import be.isach.ultracosmetics.mysql.tables.CosmeticTable;
import be.isach.ultracosmetics.mysql.tables.PlayerDataTable;
import be.isach.ultracosmetics.mysql.tables.Table;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;

public class AmmoTable
extends Table {
    private final PlayerDataTable playerData;
    private final CosmeticTable cosmeticTable;

    public AmmoTable(DataSource dataSource, String name, PlayerDataTable playerData, CosmeticTable cosmeticTable) {
        super(dataSource, name);
        this.playerData = playerData;
        this.cosmeticTable = cosmeticTable;
    }

    @Override
    public void setupTableInfo() {
        this.tableInfo.add(new UUIDColumn());
        this.tableInfo.add(new VirtualUUIDColumn());
        this.tableInfo.add(new Column<Integer>("id", "INTEGER NOT NULL", Integer.class));
        this.tableInfo.add(new Column<Integer>("ammo", "INTEGER NOT NULL DEFAULT 0", Integer.class));
        this.tableInfo.add(new ForeignKeyConstraint("uuid", this.playerData.getWrappedName(), "uuid"));
        this.tableInfo.add(new ForeignKeyConstraint("id", this.cosmeticTable.getWrappedName(), "id"));
        this.tableInfo.add(new UniqueConstraint("uuid", "id"));
    }

    public int getAmmo(UUID uuid, GadgetType type) {
        return this.select("ammo").uuid(uuid).where(this.cosmeticTable.subqueryFor(type, false)).asInt();
    }

    public Map<GadgetType, Integer> getAllAmmo(UUID uuid) {
        return this.select("ammo, type").uuid(uuid).innerJoin(new InnerJoin(this.cosmeticTable.getWrappedName(), "id")).getResults(r -> {
            HashMap ammo = new HashMap();
            while (r.next()) {
                int ammoAmount = r.getInt("ammo");
                this.ifParseable(Category.GADGETS, r.getString("type"), (Category c, CosmeticType<?> t) -> ammo.put((GadgetType)t, ammoAmount));
            }
            return ammo;
        }, true);
    }

    public void setAmmo(UUID uuid, GadgetType type, int amount) {
        this.insert("uuid", "id", "ammo").insert(AmmoTable.insertUUID(uuid), this.cosmeticTable.subqueryFor(type, true), new InsertValue(amount)).updateOnDuplicate().execute();
    }

    public void setAllAmmo(UUID uuid, Map<GadgetType, Integer> ammo) {
        this.delete().uuid(uuid).execute();
        if (ammo.size() == 0) {
            return;
        }
        InsertQuery query = this.insert("uuid", "id", "ammo");
        InsertValue uuidVal = AmmoTable.insertUUID(uuid);
        for (Map.Entry<GadgetType, Integer> entry : ammo.entrySet()) {
            if (entry.getValue() == null || entry.getValue() == 0) continue;
            query.insert(uuidVal, this.cosmeticTable.subqueryFor(entry.getKey(), true), new InsertValue(entry.getValue()));
        }
        query.updateOnDuplicate().execute();
    }
}

