/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.mysql.tables;

import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.mysql.column.Column;
import be.isach.ultracosmetics.mysql.column.ForeignKeyConstraint;
import be.isach.ultracosmetics.mysql.column.StringColumn;
import be.isach.ultracosmetics.mysql.column.UUIDColumn;
import be.isach.ultracosmetics.mysql.column.UniqueConstraint;
import be.isach.ultracosmetics.mysql.column.VirtualUUIDColumn;
import be.isach.ultracosmetics.mysql.query.InnerJoin;
import be.isach.ultracosmetics.mysql.query.InsertQuery;
import be.isach.ultracosmetics.mysql.query.InsertValue;
import be.isach.ultracosmetics.mysql.tables.CosmeticTable;
import be.isach.ultracosmetics.mysql.tables.PlayerDataTable;
import be.isach.ultracosmetics.mysql.tables.Table;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;

public class EquippedTable
extends Table {
    private final PlayerDataTable playerData;
    private final CosmeticTable cosmeticTable;

    public EquippedTable(DataSource dataSource, String name, PlayerDataTable playerData, CosmeticTable cosmeticTable) {
        super(dataSource, name);
        this.playerData = playerData;
        this.cosmeticTable = cosmeticTable;
    }

    @Override
    public void setupTableInfo() {
        this.tableInfo.add(new UUIDColumn());
        this.tableInfo.add(new VirtualUUIDColumn());
        this.tableInfo.add(new Column<Integer>("id", "INTEGER NOT NULL", Integer.class));
        this.tableInfo.add(new StringColumn("category", 32, true));
        this.tableInfo.add(new ForeignKeyConstraint("uuid", this.playerData.getWrappedName(), "uuid"));
        this.tableInfo.add(new ForeignKeyConstraint("id,category", this.cosmeticTable.getWrappedName(), "id,category"));
        this.tableInfo.add(new UniqueConstraint("uuid", "category"));
    }

    public Map<Category, CosmeticType<?>> getEquipped(UUID uuid) {
        return this.select(this.getWrappedName() + ".category, type").uuid(uuid).innerJoin(new InnerJoin(this.cosmeticTable.getWrappedName(), "id")).getResults(r -> {
            HashMap equipped = new HashMap();
            while (r.next()) {
                this.ifParseable(r.getString("category"), r.getString("type"), equipped::put);
            }
            return equipped;
        }, true);
    }

    public void setEquipped(UUID uuid, CosmeticType<?> type) {
        this.insert("uuid", "id", "category").insert(EquippedTable.insertUUID(uuid), this.cosmeticTable.subqueryFor(type, true), new InsertValue(EquippedTable.cleanCategoryName(type))).updateOnDuplicate().execute();
    }

    public void unsetEquipped(UUID uuid, Category cat) {
        this.delete().uuid(uuid).where("category", EquippedTable.cleanCategoryName(cat)).execute();
    }

    public void clearAllEquipped(UUID uuid) {
        this.delete().uuid(uuid).execute();
    }

    public void setAllEquipped(UUID uuid, Map<Category, CosmeticType<?>> equipped) {
        this.clearAllEquipped(uuid);
        if (equipped.isEmpty()) {
            return;
        }
        InsertQuery query = this.insert("uuid", "id", "category");
        InsertValue uuidVal = EquippedTable.insertUUID(uuid);
        for (Map.Entry<Category, CosmeticType<?>> entry : equipped.entrySet()) {
            query.insert(uuidVal, this.cosmeticTable.subqueryFor(entry.getValue(), true), new InsertValue(EquippedTable.cleanCategoryName(entry.getKey())));
        }
        query.updateOnDuplicate().execute();
    }
}

