/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.mysql.tables;

import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.mysql.column.Column;
import be.isach.ultracosmetics.mysql.column.ForeignKeyConstraint;
import be.isach.ultracosmetics.mysql.column.UUIDColumn;
import be.isach.ultracosmetics.mysql.column.UniqueConstraint;
import be.isach.ultracosmetics.mysql.column.VirtualUUIDColumn;
import be.isach.ultracosmetics.mysql.query.InnerJoin;
import be.isach.ultracosmetics.mysql.query.InsertQuery;
import be.isach.ultracosmetics.mysql.query.InsertValue;
import be.isach.ultracosmetics.mysql.query.StandardQuery;
import be.isach.ultracosmetics.mysql.tables.CosmeticTable;
import be.isach.ultracosmetics.mysql.tables.PlayerDataTable;
import be.isach.ultracosmetics.mysql.tables.Table;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.sql.DataSource;

public class UnlockedTable
extends Table {
    private final PlayerDataTable playerData;
    private final CosmeticTable cosmeticTable;

    public UnlockedTable(DataSource dataSource, String name, PlayerDataTable playerData, CosmeticTable cosmeticTable) {
        super(dataSource, name);
        this.playerData = playerData;
        this.cosmeticTable = cosmeticTable;
    }

    @Override
    public void setupTableInfo() {
        this.tableInfo.add(new UUIDColumn());
        this.tableInfo.add(new VirtualUUIDColumn());
        this.tableInfo.add(new Column<Integer>("id", "INTEGER NOT NULL", Integer.class));
        this.tableInfo.add(new UniqueConstraint("uuid", "id"));
        this.tableInfo.add(new ForeignKeyConstraint("uuid", this.playerData.getWrappedName(), "uuid"));
        this.tableInfo.add(new ForeignKeyConstraint("id", this.cosmeticTable.getWrappedName(), "id"));
    }

    public boolean hasUnlocked(UUID uuid, CosmeticType<?> type) {
        return this.selectVoid().uuid(uuid).where(this.cosmeticTable.subqueryFor(type, false)).exists();
    }

    public Set<CosmeticType<?>> getAllUnlocked(UUID uuid) {
        return this.select("category, type").uuid(uuid).innerJoin(new InnerJoin(this.cosmeticTable.getWrappedName(), "id")).getResults(r -> {
            HashSet unlocked = new HashSet();
            while (r.next()) {
                this.ifParseable(r.getString("category"), r.getString("type"), (Category c, CosmeticType<?> t) -> unlocked.add(t));
            }
            return unlocked;
        }, true);
    }

    public void setUnlocked(UUID uuid, Set<CosmeticType<?>> types) {
        InsertQuery query = this.insertIgnore("uuid", "id");
        types.forEach(t -> query.insert(UnlockedTable.insertUUID(uuid), this.cosmeticTable.subqueryFor((CosmeticType<?>)t, true)));
        query.execute();
    }

    public void unsetUnlocked(UUID uuid, Set<CosmeticType<?>> types) {
        StandardQuery query = this.delete().uuid(uuid).andOr();
        types.forEach(t -> query.where(this.cosmeticTable.subqueryFor((CosmeticType<?>)t, false)));
        query.execute();
    }

    public void setAllUnlocked(UUID uuid, Set<CosmeticType<?>> unlocked) {
        this.delete().uuid(uuid).execute();
        if (unlocked.size() == 0) {
            return;
        }
        InsertQuery query = this.insert("uuid", "id");
        InsertValue uuidValue = UnlockedTable.insertUUID(uuid);
        for (CosmeticType<?> type : unlocked) {
            query.insert(uuidValue, this.cosmeticTable.subqueryFor(type, true));
        }
        query.execute();
    }
}

