/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.player;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.Cosmetic;
import be.isach.ultracosmetics.cosmetics.emotes.Emote;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.hats.Hat;
import be.isach.ultracosmetics.cosmetics.morphs.Morph;
import be.isach.ultracosmetics.cosmetics.mounts.Mount;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffect;
import be.isach.ultracosmetics.cosmetics.pets.Pet;
import be.isach.ultracosmetics.cosmetics.suits.ArmorSlot;
import be.isach.ultracosmetics.cosmetics.suits.Suit;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.cosmetics.type.PetType;
import be.isach.ultracosmetics.mysql.SqlCache;
import be.isach.ultracosmetics.player.profile.CosmeticsProfile;
import be.isach.ultracosmetics.player.profile.FileCosmeticsProfile;
import be.isach.ultracosmetics.run.FallDamageManager;
import be.isach.ultracosmetics.shaded.kyori.adventure.platform.bukkit.BukkitComponentSerializer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.treasurechests.TreasureChest;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.PlayerUtils;
import com.cryptomorin.xseries.messages.ActionBar;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class UltraPlayer {
    private final UUID uuid;
    private final UltraCosmetics ultraCosmetics;
    private final Map<Category, Cosmetic<?>> equipped = new HashMap();
    private TreasureChest currentTreasureChest;
    private final CosmeticsProfile cosmeticsProfile;
    private final boolean allowDisableGadgets = SettingsManager.getConfig().getBoolean("Categories.Gadgets.Allow-Disable-Gadgets", true);
    private final boolean menuItemEnabled = SettingsManager.getConfig().getBoolean("Menu-Item.Enabled");
    private boolean canBeHitByOtherGadgets = true;
    private final Map<CosmeticType<?>, Long> cooldowns = new HashMap();
    private boolean preserveEquipped = false;
    private String clientBrand = null;

    public UltraPlayer(UUID uuid, UltraCosmetics ultraCosmetics) {
        this.uuid = uuid;
        this.ultraCosmetics = ultraCosmetics;
        this.cosmeticsProfile = UltraCosmeticsData.get().usingFileStorage() ? new FileCosmeticsProfile(this, ultraCosmetics) : new SqlCache(this, ultraCosmetics);
    }

    public double getCooldown(CosmeticType<?> type) {
        Long count = this.cooldowns.get(type);
        if (count == null || System.currentTimeMillis() > count) {
            return 0.0;
        }
        double valueMillis = count - System.currentTimeMillis();
        return valueMillis / 1000.0;
    }

    public boolean canUse(CosmeticType<?> type) {
        return this.getCooldown(type) == 0.0;
    }

    public boolean canEquip(CosmeticType<?> type) {
        return this.ultraCosmetics.getWorldGuardManager().isInShowroom(this.getBukkitPlayer()) || this.ultraCosmetics.getPermissionManager().hasPermission(this, type);
    }

    public void setCooldown(CosmeticType<?> type, double cooldown, double runTime) {
        double time;
        double d = time = this.isBypassingCooldown() ? runTime : cooldown;
        if (time == 0.0) {
            return;
        }
        this.cooldowns.put(type, (long)(time * 1000.0 + (double)System.currentTimeMillis()));
    }

    public boolean getAndSetCooldown(CosmeticType<?> type, double cooldown, double runTime) {
        if (this.canUse(type)) {
            this.setCooldown(type, cooldown, runTime);
            return true;
        }
        return false;
    }

    public void sendCooldownBar(CosmeticType<?> type, double cooldown, double runTime) {
        StringBuilder stringBuilder = new StringBuilder(ChatColor.GREEN.toString());
        double currentCooldown = this.getCooldown(type);
        double maxCooldown = this.isBypassingCooldown() ? runTime : cooldown;
        int res = (int)(currentCooldown / maxCooldown * 50.0);
        for (int i = 0; i < 50; ++i) {
            if (i == 50 - res) {
                stringBuilder.append(ChatColor.RED);
            }
            stringBuilder.append("|");
        }
        DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(Locale.US);
        otherSymbols.setDecimalSeparator('.');
        otherSymbols.setGroupingSeparator('.');
        otherSymbols.setPatternSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat("0.0", otherSymbols);
        String timeLeft = decimalFormat.format(currentCooldown) + "s";
        String name = BukkitComponentSerializer.legacy().serialize(type.getName());
        ActionBar.sendActionBar((Player)this.getBukkitPlayer(), (String)(name + String.valueOf(ChatColor.WHITE) + " " + String.valueOf(stringBuilder) + String.valueOf(ChatColor.WHITE) + " " + timeLeft));
    }

    public Player getBukkitPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    public Cosmetic<?> getCosmetic(Category category) {
        return this.equipped.get((Object)category);
    }

    public ParticleEffect getCurrentParticleEffect() {
        return (ParticleEffect)this.getCosmetic(Category.EFFECTS);
    }

    public Emote getCurrentEmote() {
        return (Emote)this.getCosmetic(Category.EMOTES);
    }

    public Gadget getCurrentGadget() {
        return (Gadget)this.getCosmetic(Category.GADGETS);
    }

    public Hat getCurrentHat() {
        return (Hat)this.getCosmetic(Category.HATS);
    }

    public Morph getCurrentMorph() {
        return (Morph)this.getCosmetic(Category.MORPHS);
    }

    public Mount getCurrentMount() {
        return (Mount)this.getCosmetic(Category.MOUNTS);
    }

    public Pet getCurrentPet() {
        return (Pet)this.getCosmetic(Category.PETS);
    }

    public Suit getCurrentSuit(ArmorSlot slot) {
        return (Suit)this.getCosmetic(Category.suitsFromSlot(slot));
    }

    public boolean hasCosmetic(Category category) {
        return this.equipped.containsKey((Object)category);
    }

    public boolean removeCosmetic(Category category) {
        if (!this.equipped.containsKey((Object)category)) {
            return false;
        }
        this.unsetCosmetic(category).clear();
        return true;
    }

    public Cosmetic<?> unsetCosmetic(Category category) {
        if (!this.preserveEquipped) {
            this.cosmeticsProfile.setEnabledCosmetic(category, (CosmeticType)null);
        }
        return this.equipped.remove((Object)category);
    }

    public void setCosmeticEquipped(Cosmetic<?> cosmetic) {
        this.removeCosmetic(cosmetic.getCategory());
        this.equipped.put(cosmetic.getCategory(), cosmetic);
        if (!this.preserveEquipped) {
            this.cosmeticsProfile.setEnabledCosmetic(cosmetic.getCategory(), cosmetic);
        }
    }

    public void addKeys(int amount) {
        this.cosmeticsProfile.addKeys(amount);
    }

    public void addKey() {
        this.addKeys(1);
    }

    public void removeKey() {
        this.addKeys(-1);
    }

    public int getKeys() {
        return this.cosmeticsProfile.getKeys();
    }

    public void saveCosmeticsProfile() {
        this.cosmeticsProfile.save();
    }

    public boolean hasCosmeticsEquipped() {
        return this.equipped.size() > 0;
    }

    public boolean clear() {
        boolean toReturn = this.hasCosmeticsEquipped();
        if (!this.preserveEquipped) {
            this.cosmeticsProfile.clearAllEquipped();
        }
        if (Category.MORPHS.isEnabled() && Bukkit.getPluginManager().isPluginEnabled("LibsDisguises") && (this.preserveEquipped || SettingsManager.isAllowedWorld(this.getBukkitPlayer().getWorld()))) {
            this.removeCosmetic(Category.MORPHS);
        }
        for (Category cat : Category.values()) {
            if (cat == Category.MORPHS) continue;
            this.removeCosmetic(cat);
        }
        this.removeTreasureChest();
        return toReturn;
    }

    public void dispose() {
        this.preserveEquipped = true;
        if (this.currentTreasureChest != null) {
            this.currentTreasureChest.forceOpen(0);
        }
        this.saveCosmeticsProfile();
        this.clear();
        this.removeMenuItem();
    }

    public void setPetName(PetType petType, String name) {
        if (name != null && name.isEmpty()) {
            name = null;
        }
        this.cosmeticsProfile.setPetName(petType, name);
        if (this.hasCosmetic(Category.PETS)) {
            ((Pet)this.getCosmetic(Category.PETS)).updateName();
        }
    }

    public Component getPetName(PetType petType) {
        String rawName = this.cosmeticsProfile.getPetName(petType);
        if (rawName == null) {
            return null;
        }
        return MessageManager.getMiniMessage().deserialize(this.cosmeticsProfile.getPetName(petType));
    }

    public void addAmmo(GadgetType type, int amount) {
        if (!UltraCosmeticsData.get().isAmmoEnabled()) {
            return;
        }
        this.cosmeticsProfile.addAmmo(type, amount);
        Gadget gadget = this.getCurrentGadget();
        if (gadget != null) {
            gadget.equipItem();
        }
    }

    public void applyVelocity(Vector vector) {
        this.getBukkitPlayer().setVelocity(vector);
        this.ultraCosmetics.getScheduler().runLaterAsync(() -> FallDamageManager.addNoFall((Entity)this.getBukkitPlayer()), 2L);
    }

    public void setGadgetsEnabled(boolean enabled) {
        this.cosmeticsProfile.setGadgetsEnabled(enabled);
        if (enabled) {
            MessageManager.send((CommandSender)this.getBukkitPlayer(), "Enabled-Gadgets", new TagResolver.Single[0]);
        } else {
            MessageManager.send((CommandSender)this.getBukkitPlayer(), "Disabled-Gadgets", new TagResolver.Single[0]);
        }
    }

    public boolean hasGadgetsEnabled() {
        return !this.allowDisableGadgets || this.cosmeticsProfile.hasGadgetsEnabled();
    }

    public void setSeeSelfMorph(boolean enabled) {
        this.cosmeticsProfile.setSeeSelfMorph(enabled);
        if (enabled) {
            MessageManager.send((CommandSender)this.getBukkitPlayer(), "Enabled-SelfMorphView", new TagResolver.Single[0]);
        } else {
            MessageManager.send((CommandSender)this.getBukkitPlayer(), "Disabled-SelfMorphView", new TagResolver.Single[0]);
        }
        if (this.hasCosmetic(Category.MORPHS)) {
            this.getCurrentMorph().setSeeSelf(enabled);
        }
    }

    public boolean canSeeSelfMorph() {
        return this.cosmeticsProfile.canSeeSelfMorph();
    }

    public int getAmmo(GadgetType type) {
        if (!UltraCosmeticsData.get().isAmmoEnabled()) {
            return 0;
        }
        return this.cosmeticsProfile.getAmmo(type);
    }

    public void removeTreasureChest() {
        if (this.currentTreasureChest == null) {
            return;
        }
        this.currentTreasureChest.clear();
        this.currentTreasureChest = null;
    }

    public void removeAmmo(GadgetType type) {
        this.addAmmo(type, -1);
    }

    public void giveMenuItem() {
        if (!this.menuItemEnabled || this.getBukkitPlayer() == null) {
            return;
        }
        this.removeMenuItem();
        ConfigurationSection section = SettingsManager.getConfig().getConfigurationSection("Menu-Item");
        int slot = section.getInt("Slot");
        ItemStack slotItem = this.getBukkitPlayer().getInventory().getItem(slot);
        ItemStack menuItem = ItemFactory.getMenuItem();
        if (slotItem != null && !slotItem.isSimilar(menuItem)) {
            this.getBukkitPlayer().getWorld().dropItemNaturally(this.getBukkitPlayer().getLocation(), slotItem);
        }
        this.getBukkitPlayer().getInventory().setItem(slot, menuItem);
    }

    public void removeMenuItem() {
        if (!this.menuItemEnabled || this.getBukkitPlayer() == null) {
            return;
        }
        ItemStack menuItem = ItemFactory.getMenuItem();
        PlayerUtils.removeItems(this.getBukkitPlayer(), arg_0 -> ((ItemStack)menuItem).isSimilar(arg_0));
    }

    public void sendMessage(String message) {
        if (message.isEmpty()) {
            return;
        }
        this.getBukkitPlayer().sendMessage(message);
    }

    public void sendMessage(Component message) {
        if (message == null || message.equals(Component.empty())) {
            return;
        }
        MessageManager.getAudiences().player(this.getBukkitPlayer()).sendMessage(message);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public TreasureChest getCurrentTreasureChest() {
        return this.currentTreasureChest;
    }

    public void setCurrentTreasureChest(TreasureChest currentTreasureChest) {
        this.currentTreasureChest = currentTreasureChest;
    }

    public void setCanBeHitByOtherGadgets(boolean canBeHitByOtherGadgets) {
        this.canBeHitByOtherGadgets = canBeHitByOtherGadgets;
    }

    public boolean canBeHitByOtherGadgets() {
        return this.canBeHitByOtherGadgets;
    }

    public boolean isOnline() {
        return Bukkit.getServer().getPlayer(this.uuid) != null;
    }

    public boolean isPreserveEquipped() {
        return this.preserveEquipped;
    }

    public void withPreserveEquipped(Runnable runnable) {
        this.preserveEquipped = true;
        try {
            runnable.run();
        }
        finally {
            this.preserveEquipped = false;
        }
    }

    public boolean isBypassingCooldown() {
        return this.getBukkitPlayer().hasPermission("ultracosmetics.bypass.cooldown");
    }

    public boolean isFilteringByOwned() {
        return this.cosmeticsProfile.isFilterByOwned();
    }

    public void setFilteringByOwned(boolean filterByOwned) {
        this.cosmeticsProfile.setFilterByOwned(filterByOwned);
    }

    public boolean isTreasureNotifying() {
        return this.cosmeticsProfile.isTreasureNotifications();
    }

    public void setTreasureNotifying(boolean treasureNotifications) {
        this.cosmeticsProfile.setTreasureNotifications(treasureNotifications);
    }

    public boolean isGeyserClient() {
        return "Geyser".equals(this.clientBrand);
    }

    public void setClientBrand(String brand) {
        this.clientBrand = brand;
    }

    public CosmeticsProfile getProfile() {
        return this.cosmeticsProfile;
    }
}

