/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.player;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.listeners.ClientBrandListener;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.run.LoadUltraPlayerTask;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class UltraPlayerManager {
    private final Map<UUID, UltraPlayer> playerCache = new ConcurrentHashMap<UUID, UltraPlayer>();
    private final UltraCosmetics ultraCosmetics;

    public UltraPlayerManager(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
    }

    public void createUltraPlayer(UUID uuid) {
        if (this.playerCache.containsKey(uuid)) {
            new LoadUltraPlayerTask(uuid, this).schedule();
            return;
        }
        this.playerCache.put(uuid, new UltraPlayer(uuid, this.ultraCosmetics));
    }

    public boolean hasUltraPlayer(UUID uuid) {
        return this.playerCache.containsKey(uuid);
    }

    public UltraPlayer getUltraPlayer(Player player) {
        if (player == null) {
            return null;
        }
        return this.getUltraPlayer(player.getUniqueId());
    }

    public UltraPlayer getUltraPlayer(UUID uuid) {
        return this.playerCache.computeIfAbsent(uuid, u -> new UltraPlayer((UUID)u, this.ultraCosmetics));
    }

    public boolean remove(Player player) {
        return this.remove(player.getUniqueId());
    }

    public boolean remove(UUID uuid) {
        return this.playerCache.remove(uuid) != null;
    }

    public Collection<UltraPlayer> getUltraPlayers() {
        return this.playerCache.values();
    }

    public void initPlayers() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            UltraPlayer up = this.getUltraPlayer(p);
            if (!SettingsManager.getConfig().getBoolean("Menu-Item.Enabled") || !SettingsManager.isAllowedWorld(p.getWorld())) continue;
            up.giveMenuItem();
        }
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this.ultraCosmetics, "minecraft:brand", (PluginMessageListener)new ClientBrandListener(this.ultraCosmetics));
    }

    public void dispose() {
        Collection<UltraPlayer> set = this.playerCache.values();
        for (UltraPlayer cp : set) {
            cp.dispose();
        }
        this.playerCache.clear();
    }
}

