/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.shaded.kyori.adventure.nbt;

import be.isach.ultracosmetics.shaded.kyori.adventure.nbt.BinaryTag;
import be.isach.ultracosmetics.shaded.kyori.adventure.nbt.BinaryTagType;
import be.isach.ultracosmetics.shaded.kyori.adventure.nbt.BinaryTagTypes;
import be.isach.ultracosmetics.shaded.kyori.adventure.nbt.ListBinaryTag;
import be.isach.ultracosmetics.shaded.kyori.adventure.nbt.ListBinaryTagImpl;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ListTagBuilder<T extends BinaryTag>
implements ListBinaryTag.Builder<T> {
    @Nullable
    private List<BinaryTag> tags;
    private final boolean permitsHeterogeneity;
    private BinaryTagType<? extends BinaryTag> elementType;

    ListTagBuilder(boolean permitsHeterogeneity) {
        this(permitsHeterogeneity, BinaryTagTypes.END);
    }

    ListTagBuilder(boolean permitsHeterogeneity, BinaryTagType<? extends BinaryTag> type) {
        this.permitsHeterogeneity = permitsHeterogeneity;
        this.elementType = type;
    }

    @Override
    public @NotNull ListBinaryTag.Builder<T> add(BinaryTag tag) {
        this.elementType = ListBinaryTagImpl.validateTagType(tag, this.elementType, this.permitsHeterogeneity);
        if (this.tags == null) {
            this.tags = new ArrayList<BinaryTag>();
        }
        this.tags.add(tag);
        return this;
    }

    @Override
    public @NotNull ListBinaryTag.Builder<T> add(Iterable<? extends T> tagsToAdd) {
        for (BinaryTag tag : tagsToAdd) {
            this.add(tag);
        }
        return this;
    }

    @Override
    @NotNull
    public ListBinaryTag build() {
        if (this.tags == null) {
            return ListBinaryTag.empty();
        }
        return new ListBinaryTagImpl(this.elementType, this.permitsHeterogeneity, new ArrayList<BinaryTag>(this.tags));
    }
}

