/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.shaded.mobchip.abstraction;

import be.isach.ultracosmetics.shaded.mobchip.EntityBody;
import be.isach.ultracosmetics.shaded.mobchip.ai.attribute.Attribute;
import be.isach.ultracosmetics.shaded.mobchip.ai.attribute.AttributeInstance;
import be.isach.ultracosmetics.shaded.mobchip.ai.behavior.BehaviorResult;
import be.isach.ultracosmetics.shaded.mobchip.ai.controller.EntityController;
import be.isach.ultracosmetics.shaded.mobchip.ai.enderdragon.CustomPhase;
import be.isach.ultracosmetics.shaded.mobchip.ai.enderdragon.DragonPhase;
import be.isach.ultracosmetics.shaded.mobchip.ai.goal.CustomPathfinder;
import be.isach.ultracosmetics.shaded.mobchip.ai.goal.Pathfinder;
import be.isach.ultracosmetics.shaded.mobchip.ai.goal.WrappedPathfinder;
import be.isach.ultracosmetics.shaded.mobchip.ai.gossip.EntityGossipContainer;
import be.isach.ultracosmetics.shaded.mobchip.ai.memories.Memory;
import be.isach.ultracosmetics.shaded.mobchip.ai.memories.MemoryStatus;
import be.isach.ultracosmetics.shaded.mobchip.ai.navigation.EntityNavigation;
import be.isach.ultracosmetics.shaded.mobchip.ai.schedule.EntityScheduleManager;
import be.isach.ultracosmetics.shaded.mobchip.ai.schedule.Schedule;
import be.isach.ultracosmetics.shaded.mobchip.ai.sensing.EntitySenses;
import be.isach.ultracosmetics.shaded.mobchip.ai.sensing.Sensor;
import be.isach.ultracosmetics.shaded.mobchip.combat.EntityCombatTracker;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Creature;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Villager;

public interface ChipUtil {
    public static final String CLASS_TAG = "==";

    public void addCustomPathfinder(CustomPathfinder var1, int var2, boolean var3);

    public Set<WrappedPathfinder> getGoals(Mob var1, boolean var2);

    public Collection<WrappedPathfinder> getRunningGoals(Mob var1, boolean var2);

    public void setFlag(Mob var1, Pathfinder.PathfinderFlag var2, boolean var3, boolean var4);

    public void addPathfinder(Pathfinder var1, int var2, boolean var3);

    public void removePathfinder(Pathfinder var1, boolean var2);

    default public void clearPathfinders(Mob mob, boolean target) {
        this.getGoals(mob, target).forEach(w -> this.removePathfinder(w.getPathfinder(), target));
    }

    default public void addPathfinders(Collection<WrappedPathfinder> c, boolean target) {
        for (WrappedPathfinder p : c) {
            this.addPathfinder(p.getPathfinder(), p.getPriority(), target);
        }
    }

    public BehaviorResult runBehavior(Mob var1, String var2, Object ... var3);

    public BehaviorResult runBehavior(Mob var1, String var2, String var3, Object ... var4);

    public EntityController getController(Mob var1);

    public EntityNavigation getNavigation(Mob var1);

    public EntityBody getBody(Mob var1);

    public EntityScheduleManager getManager(Mob var1);

    public EntityGossipContainer getGossipContainer(Villager var1);

    public EntityCombatTracker getCombatTracker(Mob var1);

    public void setCustomPhase(EnderDragon var1, CustomPhase var2);

    public void knockback(EnderDragon var1, List<Entity> var2);

    public <T> void setMemory(Mob var1, Memory<T> var2, T var3);

    public void setMemory(Mob var1, String var2, Object var3);

    public <T> void setMemory(Mob var1, Memory<T> var2, T var3, long var4);

    public <T> T getMemory(Mob var1, Memory<T> var2);

    public long getExpiry(Mob var1, Memory<?> var2);

    public boolean contains(Mob var1, Memory<?> var2);

    public void removeMemory(Mob var1, Memory<?> var2);

    public boolean isRestricted(Mob var1);

    public void clearRestriction(Mob var1);

    public void restrictTo(Mob var1, double var2, double var4, double var6, int var8);

    public Location getRestriction(Mob var1);

    public int getRestrictionRadius(Mob var1);

    public boolean hasRestriction(Mob var1);

    public boolean canSee(Mob var1, Entity var2);

    public Schedule getDefaultSchedule(String var1);

    public Attribute registerAttribute(NamespacedKey var1, double var2, double var4, double var6, boolean var8);

    public boolean existsAttribute(NamespacedKey var1);

    public Attribute getAttribute(NamespacedKey var1);

    public Attribute getDefaultAttribute(String var1);

    public AttributeInstance getAttributeInstance(Mob var1, Attribute var2);

    public DragonPhase fromBukkit(EnderDragon var1, EnderDragon.Phase var2);

    public DragonPhase getCurrentPhase(EnderDragon var1);

    public void registerMemory(Memory<?> var1);

    public boolean existsMemory(Memory<?> var1);

    public void registerSensor(Sensor<?> var1);

    public boolean existsSensor(NamespacedKey var1);

    public Sensor<?> getSensor(NamespacedKey var1);

    public EntitySenses getSenses(Mob var1);

    public MemoryStatus getMemoryStatus(Mob var1, Memory<?> var2);

    public EnderCrystal getNearestCrystal(EnderDragon var1);

    default public void updateActivities(Creature c) {
    }

    default public BehaviorResult hearNoteblock(Creature c, Location loc) {
        return BehaviorResult.STOPPED;
    }

    default public BehaviorResult setDisturbanceLocation(Creature c, Location loc) {
        return BehaviorResult.STOPPED;
    }

    default public void updateGoals(Map<Integer, Pathfinder> goals, Map<Integer, Boolean> target) {
        try {
            for (Map.Entry<Integer, Pathfinder> e : goals.entrySet()) {
                this.addPathfinder(e.getValue(), e.getKey(), target.get(e.getKey()));
            }
        }
        catch (ClassCastException e) {
            Bukkit.getLogger().severe("[MobChip] Invalid Projectile Source");
            ChipUtil.printStackTrace(e);
        }
    }

    public static Class<?>[] getArgTypes(Object ... args) {
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            try {
                types[i] = (Class)args[i].getClass().getDeclaredField("TYPE").get(null);
                continue;
            }
            catch (ReflectiveOperationException ignored) {
                types[i] = args[i].getClass();
            }
        }
        return types;
    }

    public static String bukkitToCraftBukkit() {
        String bukkit;
        switch (bukkit = Bukkit.getServer().getBukkitVersion().split("-")[0]) {
            case "1.20.1": {
                return "1_20_R1";
            }
            case "1.20.2": {
                return "1_20_R2";
            }
            case "1.20.3": 
            case "1.20.4": {
                return "1_20_R3";
            }
            case "1.20.5": 
            case "1.20.6": {
                return "1_20_R4";
            }
            case "1.21": 
            case "1.21.1": {
                return "1_21_R1";
            }
            case "1.21.2": 
            case "1.21.3": {
                return "1_21_R2";
            }
            case "1.21.4": {
                return "1_21_R3";
            }
            case "1.21.5": {
                return "1_21_R4";
            }
        }
        throw new IllegalStateException("Unsupported version: " + bukkit);
    }

    public static String getServerVersion() {
        try {
            return Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].substring(1);
        }
        catch (IndexOutOfBoundsException e) {
            return ChipUtil.bukkitToCraftBukkit();
        }
    }

    public static ChipUtil getWrapper() {
        String pkg = ChipUtil.class.getPackage().getName() + ".v" + ChipUtil.getServerVersion();
        try {
            Constructor<ChipUtil> constr = Class.forName(pkg + ".ChipUtil" + ChipUtil.getServerVersion()).asSubclass(ChipUtil.class).getDeclaredConstructor(new Class[0]);
            constr.setAccessible(true);
            return constr.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Invalid Version: " + ChipUtil.getServerVersion() + " (Could not load " + pkg + ".ChipUtil" + ChipUtil.getServerVersion() + ")", e);
        }
    }

    public static void printStackTrace(Throwable e) {
        Bukkit.getLogger().severe(e.getClass().getName() + ": " + e.getMessage());
        for (StackTraceElement s : e.getStackTrace()) {
            Bukkit.getLogger().severe(s.toString());
        }
        if (e.getCause() != null) {
            Bukkit.getLogger().severe("Caused by:");
            ChipUtil.printStackTrace(e.getCause());
        }
    }
}

