/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.shaded.mobchip.abstraction.v1_20_R4;

import be.isach.ultracosmetics.shaded.mobchip.abstraction.v1_20_R4.ChipUtil1_20_R4;
import be.isach.ultracosmetics.shaded.mobchip.ai.sensing.EntitySenses;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Mob;
import org.jetbrains.annotations.NotNull;

final class EntitySenses1_20_R4
implements EntitySenses {
    private final Mob m;
    private final EntityInsentient nmsMob;
    private final Map<SensorType<?>, Sensor<?>> sensorsHandle = new HashMap();

    public EntitySenses1_20_R4(Mob m) {
        this.m = m;
        this.nmsMob = ChipUtil1_20_R4.toNMS(m);
        try {
            Field sensorsF = BehaviorController.class.getDeclaredField("e");
            sensorsF.setAccessible(true);
            Map sensors = (Map)sensorsF.get(this.nmsMob.dS());
            this.sensorsHandle.putAll(sensors);
        }
        catch (ReflectiveOperationException e) {
            Bukkit.getLogger().severe(e.getMessage());
            for (StackTraceElement st : e.getStackTrace()) {
                Bukkit.getLogger().severe(st.toString());
            }
        }
    }

    private void save() {
        try {
            Field sensorsF = BehaviorController.class.getDeclaredField("e");
            sensorsF.setAccessible(true);
            sensorsF.set(this.nmsMob.dS(), this.sensorsHandle);
        }
        catch (ReflectiveOperationException e) {
            Bukkit.getLogger().severe(e.getMessage());
            for (StackTraceElement st : e.getStackTrace()) {
                Bukkit.getLogger().severe(st.toString());
            }
        }
    }

    @Override
    @NotNull
    public Mob getEntity() {
        return this.m;
    }

    @Override
    @NotNull
    public List<be.isach.ultracosmetics.shaded.mobchip.ai.sensing.Sensor<?>> getSensors() {
        return this.sensorsHandle.values().stream().map(ChipUtil1_20_R4::fromNMS).collect(Collectors.toList());
    }

    @Override
    public void addSensor(@NotNull be.isach.ultracosmetics.shaded.mobchip.ai.sensing.Sensor<?> sensor) throws IllegalArgumentException {
        if (!new ChipUtil1_20_R4().existsSensor(sensor.getKey())) {
            throw new IllegalArgumentException("Unregistered Sensor: " + String.valueOf(sensor.getKey()));
        }
        this.sensorsHandle.put(ChipUtil1_20_R4.toNMSType(sensor), ChipUtil1_20_R4.toNMS(sensor));
        this.save();
    }

    @Override
    public void removeSensor(@NotNull be.isach.ultracosmetics.shaded.mobchip.ai.sensing.Sensor<?> sensor) {
        if (!new ChipUtil1_20_R4().existsSensor(sensor.getKey())) {
            throw new IllegalArgumentException("Unregistered Sensor: " + String.valueOf(sensor.getKey()));
        }
        this.removeSensor(sensor.getKey());
    }

    @Override
    public void removeSensor(@NotNull NamespacedKey key) {
        if (!new ChipUtil1_20_R4().existsSensor(key)) {
            throw new IllegalArgumentException("Unregistered Sensor: " + String.valueOf(key));
        }
        MinecraftKey keyH = ChipUtil1_20_R4.toNMS(key);
        Iterator<Map.Entry<SensorType<?>, Sensor<?>>> it = this.sensorsHandle.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<SensorType<?>, Sensor<?>> entry = it.next();
            SensorType<?> currentType = entry.getKey();
            MinecraftKey currentKey = BuiltInRegistries.C.b(currentType);
            if (!currentKey.equals((Object)keyH)) continue;
            it.remove();
            break;
        }
        this.sensorsHandle.clear();
        this.sensorsHandle.putAll(ImmutableList.copyOf(it).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        this.save();
    }

    @Override
    public boolean hasSensor(@NotNull NamespacedKey key) {
        AtomicBoolean b = new AtomicBoolean(false);
        for (SensorType<?> t : this.sensorsHandle.keySet()) {
            MinecraftKey currentKey = BuiltInRegistries.C.b(t);
            if (!ChipUtil1_20_R4.toNMS(key).equals((Object)currentKey)) continue;
            b.set(true);
            break;
        }
        return b.get();
    }
}

