/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.shaded.mobchip.bukkit;

import be.isach.ultracosmetics.shaded.mobchip.ai.behavior.BehaviorResult;
import be.isach.ultracosmetics.shaded.mobchip.ai.behavior.WardenBehavior;
import be.isach.ultracosmetics.shaded.mobchip.ai.memories.EntityMemory;
import be.isach.ultracosmetics.shaded.mobchip.ai.memories.Unit;
import be.isach.ultracosmetics.shaded.mobchip.bukkit.BukkitUpdatableCreatureBehavior;
import org.bukkit.Location;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Warden;
import org.jetbrains.annotations.NotNull;

class BukkitWardenBehavior
extends BukkitUpdatableCreatureBehavior
implements WardenBehavior {
    final Warden m;

    public BukkitWardenBehavior(Warden m) {
        super((Creature)m);
        this.m = m;
    }

    @Override
    BehaviorResult run(String behaviorName, Object ... args) {
        return wrapper.runBehavior((Mob)this.m, behaviorName, "net.minecraft.world.entity.ai.behavior.warden", args);
    }

    @Override
    @NotNull
    public BehaviorResult setDisturbanceLocation(@NotNull Location loc) {
        return wrapper.setDisturbanceLocation((Creature)this.m, loc);
    }

    @Override
    @NotNull
    public BehaviorResult dig(int duration) {
        wrapper.removeMemory((Mob)this.m, EntityMemory.ATTACK_TARGET);
        wrapper.removeMemory((Mob)this.m, EntityMemory.WALKING_TARGET);
        return this.run("Digging", duration);
    }

    @Override
    @NotNull
    public BehaviorResult emerge(int duration) {
        wrapper.setMemory((Mob)this.m, EntityMemory.IS_EMERGING, Unit.INSTANCE, 134L);
        wrapper.removeMemory((Mob)this.m, EntityMemory.WALKING_TARGET);
        return this.run("Emerging", duration);
    }

    @Override
    @NotNull
    public BehaviorResult roar() {
        return this.run("Roar", new Object[0]);
    }

    @Override
    @NotNull
    public BehaviorResult sonicBoom() {
        return this.run("SonicBoom", new Object[0]);
    }

    @Override
    @NotNull
    public BehaviorResult sniff(int duration) {
        this.run("TryToSniff", new Object[0]);
        return this.run("Sniffing", duration);
    }
}

