/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.shaded.mobchip.util;

import be.isach.ultracosmetics.shaded.mobchip.util.Position;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PositionPath {
    private final List<Position> positions = new ArrayList<Position>();
    private final Location targetLocation;
    private int nextPositionIndex;

    public PositionPath(@Nullable Iterable<? extends Position> positions, @NotNull Location targetLocation) throws IllegalArgumentException {
        if (targetLocation == null) {
            throw new IllegalArgumentException("Target Position cannot be null!");
        }
        if (positions != null) {
            this.positions.addAll(ImmutableList.copyOf(positions).stream().filter(Objects::nonNull).collect(Collectors.toList()));
        }
        this.targetLocation = targetLocation;
    }

    @Nullable
    public World getWorld() {
        return this.targetLocation.getWorld();
    }

    public int getNextPositionIndex() {
        return this.nextPositionIndex;
    }

    public Position advance() throws IllegalStateException {
        if (this.isReached()) {
            throw new IllegalStateException("Path has no more positions!");
        }
        ++this.nextPositionIndex;
        return this.positions.get(this.nextPositionIndex);
    }

    public void addPosition(@NotNull Position position) throws IllegalArgumentException {
        if (position == null) {
            throw new IllegalArgumentException("Position cannot be null!");
        }
        this.positions.add(position);
    }

    public void addPosition(@NotNull Position position, int index) throws IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("Index cannot be negative!");
        }
        if (position == null) {
            throw new IllegalArgumentException("Position cannot be null!");
        }
        this.positions.add(index, position);
    }

    @Nullable
    public Position getEndPosition() {
        return this.positions.get(this.positions.size() - 1);
    }

    @Nullable
    public Position getPosition(int index) {
        return this.positions.get(index);
    }

    @NotNull
    public Position getCurrentPosition() {
        return this.positions.get(this.nextPositionIndex);
    }

    @NotNull
    public List<Position> getPositions() {
        return ImmutableList.copyOf(this.positions);
    }

    @NotNull
    public Location getTargetLocation() {
        return this.targetLocation;
    }

    public boolean isReached() {
        return this.nextPositionIndex >= this.positions.size();
    }

    public boolean notStarted() {
        return this.nextPositionIndex == 0;
    }
}

