/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.treasurechests;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.task.UltraTask;
import be.isach.ultracosmetics.treasurechests.PlaceChestRunnable;
import be.isach.ultracosmetics.treasurechests.TreasureChest;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import java.awt.Color;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class ChestParticleRunnable
extends UltraTask {
    private static final Vector Y_AXIS = new Vector(0, 1, 0);
    private final TreasureChest chest;
    private final UltraCosmetics uc;
    private final boolean large;
    private final int totalChests;
    private int i;
    private PlaceChestRunnable chestRunnable = null;

    public ChestParticleRunnable(TreasureChest chest) {
        this.chest = chest;
        this.uc = UltraCosmeticsData.get().getPlugin();
        this.large = chest.isLarge();
        this.totalChests = !this.large && chest.getChestsLeft() > 4 ? 4 : chest.getChestsLeft();
        this.i = this.totalChests - 1;
    }

    @Override
    public void run() {
        if (this.i < 0) {
            this.cancel();
            return;
        }
        Player player = this.chest.getPlayer();
        if (player == null || this.uc.getPlayerManager().getUltraPlayer(player).getCurrentTreasureChest() != this.chest) {
            this.cancel();
            return;
        }
        int animationTime = 0;
        XParticle particleEffect = this.chest.getParticleEffect();
        Location chestLocation = this.getChestLocation();
        if (particleEffect != null) {
            this.playHelix(particleEffect, chestLocation, 0.0f);
            this.playHelix(particleEffect, chestLocation, 3.5f);
            animationTime = 30;
        }
        this.chestRunnable = new PlaceChestRunnable(this.chest, chestLocation.getBlock(), this.i--, animationTime);
        this.chestRunnable.schedule();
    }

    @Override
    public void schedule() {
        this.task = this.getScheduler().runAtLocationTimer(this.chest.getCenter(), this::run, 0L, 50L);
    }

    private Location getChestLocation() {
        Location chestLocation = this.chest.getCenter().clone().add(0.5, 0.0, 0.5);
        double horizontalOffset = 0.0;
        if (this.totalChests > 4 && this.totalChests < 9) {
            horizontalOffset = this.i < 4 ? 1.0 : -1.0;
        } else if (this.totalChests > 8) {
            if (this.i > 7) {
                horizontalOffset = 1.0;
            } else if (this.i > 3) {
                horizontalOffset = -1.0;
            }
        }
        BlockFace face = ChestParticleRunnable.getDirection(this.i);
        Vector v = new Vector(face.getModX(), face.getModY(), face.getModZ());
        Vector perpendicular = v.clone().crossProduct(Y_AXIS).multiply(horizontalOffset);
        v.multiply(this.large ? 3 : 2).add(perpendicular);
        return chestLocation.add(v);
    }

    public static BlockFace getDirection(int direction) {
        return switch (direction % 4) {
            case 0 -> BlockFace.WEST;
            case 1 -> BlockFace.EAST;
            case 2 -> BlockFace.NORTH;
            default -> BlockFace.SOUTH;
        };
    }

    public void propogateCancel() {
        this.cancel();
        if (this.chestRunnable != null) {
            this.chestRunnable.cancel();
        }
    }

    private void playHelix(XParticle particle, Location loc, float offset) {
        ParticleDisplay display = ParticleDisplay.of((XParticle)particle);
        if (particle == XParticle.DUST) {
            display.withColor(Color.RED);
        }
        double[] radius = new double[]{0.0};
        double[] step = new double[]{0.0};
        double y = loc.getY();
        double inc = 0.12566370614359174;
        Location location = loc.clone().add(0.0, 3.0, 0.0);
        UltraCosmeticsData.get().getPlugin().getScheduler().runAtEntityTimer((Entity)this.chest.getPlayer(), task -> {
            double angle = step[0] * 0.12566370614359174 + (double)offset;
            Vector v = new Vector(Math.cos(angle), 0.0, Math.sin(angle)).multiply(radius[0]);
            display.spawn(location);
            location.subtract(v).subtract(0.0, 0.1, 0.0);
            if (location.getY() <= y) {
                task.cancel();
            }
            step[0] = step[0] + 4.0;
            radius[0] = radius[0] + (double)0.02f;
        }, 0L, 1L);
    }
}

