/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.treasurechests;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.CustomConfiguration;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.MiniMessage;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.ItemFactory;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CommandReward {
    private final String name;
    private final ItemStack stack;
    private final int chance;
    private final String rawMessage;
    private boolean messageEnabled;
    private final List<String> commands;

    public CommandReward(String path) {
        CustomConfiguration config = UltraCosmeticsData.get().getPlugin().getConfig();
        MiniMessage mm = MessageManager.getMiniMessage();
        this.name = MessageManager.toLegacy(mm.deserialize(config.getString(path + ".Name")));
        this.stack = ItemFactory.getItemStackFromConfig(path + ".Material");
        this.chance = config.getInt(path + ".Chance");
        this.messageEnabled = config.getBoolean(path + ".Message.enabled");
        this.rawMessage = config.getString(path + ".Message.message");
        this.commands = config.getStringList(path + ".Commands");
    }

    public int getChance() {
        return this.chance;
    }

    public boolean isMessageEnabled() {
        return this.messageEnabled;
    }

    public void setMessageEnabled(boolean messageEnabled) {
        this.messageEnabled = messageEnabled;
    }

    public Component getMessage(Player player) {
        if (this.rawMessage == null) {
            return null;
        }
        return MessageManager.getMiniMessage().deserialize(this.rawMessage, (TagResolver)Placeholder.unparsed("name", player.getName()));
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public String getName() {
        return this.name;
    }

    public ItemStack getItemStack() {
        return this.stack.clone();
    }
}

