/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.treasurechests;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.player.UltraPlayerManager;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import be.isach.ultracosmetics.treasurechests.PlaceBlocksRunnable;
import be.isach.ultracosmetics.treasurechests.PlayerBounceRunnable;
import be.isach.ultracosmetics.treasurechests.TreasureChestDesign;
import be.isach.ultracosmetics.treasurechests.TreasureLocation;
import be.isach.ultracosmetics.treasurechests.TreasureRandomizer;
import be.isach.ultracosmetics.treasurechests.loot.LootReward;
import be.isach.ultracosmetics.util.Area;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.SmartLogger;
import be.isach.ultracosmetics.util.StructureRollback;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.particles.XParticle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Lidded;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class TreasureChest
implements Listener {
    private final StructureRollback rollback;
    private final List<Block> unopenedChests = new ArrayList<Block>();
    private final StructureRollback chestRollback = new StructureRollback();
    private final UUID owner;
    private final TreasureRandomizer randomGenerator;
    private final Location center;
    private final Block centerBlock;
    private final XParticle particleEffect;
    private int chestsLeft = SettingsManager.getConfig().getInt("TreasureChests.Count", 4);
    private final Player player;
    private final Set<Item> items = new HashSet<Item>();
    private final Set<ArmorStand> holograms = new HashSet<ArmorStand>();
    private boolean stopping;
    private boolean cooldown = false;
    private final TreasureChestDesign design;
    private final Location preLoc;
    private final TreasureLocation treasureLoc;
    private final boolean large;
    private final PlaceBlocksRunnable blocksRunnable;
    private final boolean allowDamage;

    public TreasureChest(UUID owner, TreasureChestDesign design, Location preLoc, TreasureLocation destLoc) {
        this.design = design;
        this.particleEffect = design.getEffect();
        this.owner = owner;
        this.preLoc = preLoc;
        this.treasureLoc = destLoc;
        this.large = SettingsManager.getConfig().getBoolean("TreasureChests.Large");
        this.allowDamage = SettingsManager.getConfig().getBoolean("TreasureChests.Allow-Damage");
        if (this.chestsLeft > 4) {
            if (this.large && this.chestsLeft > 12) {
                this.chestsLeft = 12;
            } else if (!this.large) {
                this.chestsLeft = 4;
            }
        }
        if (this.chestsLeft < 1) {
            this.chestsLeft = 1;
        }
        UltraCosmetics uc = UltraCosmeticsData.get().getPlugin();
        UltraPlayerManager pm = uc.getPlayerManager();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)uc);
        this.player = this.getPlayer();
        Location playerLoc = destLoc == null ? this.player.getLocation() : destLoc.toLocation(this.player);
        this.centerBlock = playerLoc.getBlock();
        this.center = this.centerBlock.getLocation();
        this.rollback = new StructureRollback(new Area(this.center.clone().subtract(0.0, 1.0, 0.0), this.large ? 3 : 2, 3));
        if (!BlockUtils.isAir(this.centerBlock.getType())) {
            this.rollback.setToRestore(this.centerBlock, Material.AIR);
        }
        if (pm.getUltraPlayer(this.getPlayer()).getCurrentMorph() != null) {
            pm.getUltraPlayer(this.getPlayer()).setSeeSelfMorph(false);
        }
        this.randomGenerator = new TreasureRandomizer(this.getPlayer(), this.getPlayer().getLocation());
        this.blocksRunnable = new PlaceBlocksRunnable(this);
        this.blocksRunnable.schedule();
        UltraCosmeticsData.get().getPlugin().getScheduler().runAtEntityLater((Entity)this.player, () -> {
            if (pm.getUltraPlayer(this.player) != null && pm.getUltraPlayer(this.player).getCurrentTreasureChest() == this) {
                this.forceOpen(45);
            }
        }, 1200L);
        pm.getUltraPlayer(this.getPlayer()).setCurrentTreasureChest(this);
        new PlayerBounceRunnable(this).schedule();
    }

    public Player getPlayer() {
        if (this.owner != null) {
            return Bukkit.getPlayer((UUID)this.owner);
        }
        return null;
    }

    public void clear() {
        this.rollback.rollback();
        if (this.stopping) {
            this.cleanup();
        } else {
            UltraCosmeticsData.get().getPlugin().getScheduler().runAtEntityLater((Entity)this.getPlayer(), this::cleanup, 30L);
        }
    }

    private void cleanup() {
        for (ArmorStand hologram : this.holograms) {
            hologram.remove();
        }
        for (Item item : this.items) {
            item.remove();
        }
        this.cancelRunnables();
        this.items.clear();
        this.unopenedChests.clear();
        this.holograms.clear();
        this.rollback.cleanup();
        this.chestRollback.cleanup();
        if (this.getPlayer() != null) {
            UltraCosmeticsData.get().getPlugin().getPlayerManager().getUltraPlayer(this.getPlayer()).setCurrentTreasureChest(null);
            if (this.preLoc != null) {
                UltraCosmeticsData.get().getPlugin().getScheduler().teleportAsync((Entity)this.getPlayer(), this.preLoc);
            }
        }
        HandlerList.unregisterAll((Listener)this);
    }

    private void cancelRunnables() {
        this.blocksRunnable.propagateCancel();
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        if (event.getPlayer() == this.getPlayer() && !event.getTo().getBlock().equals(this.centerBlock)) {
            event.setCancelled(true);
            UltraCosmeticsData.get().getPlugin().getScheduler().teleportAsync((Entity)this.getPlayer(), event.getFrom());
        }
    }

    public void forceOpen(int delay) {
        if (delay == 0) {
            this.stopping = true;
            for (int i = 0; i < this.chestsLeft; ++i) {
                LootReward reward = this.randomGenerator.giveRandomThing(this, true);
                String[] names = reward.getName();
                MessageManager.send((CommandSender)this.getPlayer(), "You-Won-Treasure-Chests", Placeholder.unparsed("name", names[names.length - 1]));
            }
            return;
        }
        for (Block b : this.unopenedChests) {
            TreasureChest.setLidPosition(b, true);
            this.randomGenerator.setLocation(b.getLocation().clone().add(0.0, 1.0, 0.0));
            LootReward reward = this.randomGenerator.giveRandomThing(this, false);
            this.items.add(this.spawnItem(reward.getStack(), b.getLocation()));
            UltraCosmeticsData.get().getPlugin().getScheduler().runAtLocationLater(b.getLocation(), () -> this.makeHolograms(b.getLocation(), reward), 15L);
            --this.chestsLeft;
        }
        this.unopenedChests.clear();
        UltraCosmeticsData.get().getPlugin().getScheduler().runAtEntityLater((Entity)this.getPlayer(), this::clear, (long)delay);
    }

    private void makeHolograms(Location location, LootReward reward) {
        String[] names = reward.getName();
        Location loc = location.clone().add(0.5, 0.3, 0.5);
        for (int i = names.length - 1; i >= 0; --i) {
            this.spawnHologram(loc, names[i]);
            loc.add(0.0, 0.25, 0.0);
        }
    }

    private ArmorStand spawnHologram(Location location, String s) {
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        armorStand.setSmall(true);
        armorStand.setGravity(false);
        armorStand.setVisible(false);
        armorStand.setBasePlate(false);
        armorStand.setCustomName(s);
        armorStand.setCustomNameVisible(true);
        armorStand.setPersistent(false);
        armorStand.setMetadata("C_AD_ArmorStand", (MetadataValue)new FixedMetadataValue((Plugin)UltraCosmeticsData.get().getPlugin(), (Object)"C_AD_ArmorStand"));
        this.holograms.add(armorStand);
        return armorStand;
    }

    public boolean isSpecialEntity(Entity entity) {
        return this.items.contains(entity) || this.holograms.contains(entity);
    }

    public static void setLidPosition(Block block, boolean open) {
        try {
            Lidded state = (Lidded)block.getState();
            if (open) {
                state.open();
            } else {
                state.close();
            }
            ((BlockState)state).update();
        }
        catch (ClassCastException | NoClassDefFoundError throwable) {
            // empty catch block
        }
    }

    @EventHandler
    public void onInter(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (this.rollback.containsBlock(block)) {
            event.setCancelled(true);
            return;
        }
        if (!this.chestRollback.containsBlock(block)) {
            return;
        }
        event.setCancelled(true);
        if (!this.unopenedChests.contains(block)) {
            return;
        }
        if (event.getPlayer() != this.getPlayer() || this.cooldown) {
            return;
        }
        TreasureChest.setLidPosition(block, true);
        Location loc = block.getLocation();
        this.randomGenerator.setLocation(loc.clone().add(0.0, 1.0, 0.0));
        LootReward reward = this.randomGenerator.giveRandomThing(this, false);
        this.cooldown = true;
        UltraCosmeticsData.get().getPlugin().getScheduler().runLaterAsync(() -> {
            this.cooldown = false;
        }, 3L);
        ItemStack is = reward.getStack();
        this.items.add(this.spawnItem(is, loc));
        UltraCosmeticsData.get().getPlugin().getScheduler().runAtLocationLater(loc, () -> this.makeHolograms(loc, reward), 15L);
        --this.chestsLeft;
        this.unopenedChests.remove(block);
        if (this.chestsLeft == 0) {
            UltraCosmeticsData.get().getPlugin().getScheduler().runAtLocationLater(loc, this::clear, 50L);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (!this.allowDamage && event.getEntity() == this.getPlayer()) {
            event.setCancelled(true);
        }
    }

    private Item spawnItem(ItemStack stack, Location loc) {
        return ItemFactory.spawnUnpickableItem(stack, loc.clone().add(0.5, 1.2, 0.5), new Vector(0.0, 0.25, 0.0));
    }

    @EventHandler
    public void onKick(PlayerKickEvent event) {
        if (event.getPlayer() == this.getPlayer() && event.getReason().equals("Flying is not enabled on this server")) {
            UltraCosmeticsData.get().getPlugin().getSmartLogger().write(SmartLogger.LogLevel.INFO, "Cancelled flight kick while opening treasure chest");
            event.setCancelled(true);
            UltraCosmeticsData.get().getPlugin().getScheduler().teleportAsync((Entity)this.getPlayer(), this.center);
        }
    }

    public TreasureLocation getTreasureLocation() {
        return this.treasureLoc;
    }

    public XParticle getParticleEffect() {
        return this.particleEffect;
    }

    public Location getCenter() {
        return this.center.clone();
    }

    public TreasureChestDesign getDesign() {
        return this.design;
    }

    public void addChest(Block b, Material newType) {
        this.unopenedChests.add(b);
        this.chestRollback.setToRestore(b, newType);
    }

    public void addRestoreBlock(Block b, XMaterial newType) {
        this.rollback.setToRestore(b, newType);
    }

    public int getChestsLeft() {
        return this.chestsLeft;
    }

    @EventHandler
    public void onItemMerge(ItemMergeEvent event) {
        if (this.items.contains(event.getEntity()) || this.items.contains(event.getTarget())) {
            event.setCancelled(true);
        }
    }

    public boolean isLarge() {
        return this.large;
    }
}

