/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.treasurechests;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.treasurechests.ChestType;
import be.isach.ultracosmetics.util.ItemFactory;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.particles.XParticle;
import java.util.Locale;

public class TreasureChestDesign {
    private final XMaterial center;
    private final XMaterial blocks2;
    private final XMaterial blocks3;
    private final XMaterial belowChests;
    private final XMaterial barriers;
    private ChestType chestType;
    private XParticle effect;

    public TreasureChestDesign(String path) {
        this.center = this.getXMaterial(path + ".center-block");
        this.blocks2 = this.getXMaterial(path + ".around-center");
        this.blocks3 = this.getXMaterial(path + ".third-blocks");
        this.belowChests = this.getXMaterial(path + ".below-chests");
        this.barriers = this.getXMaterial(path + ".barriers");
        String chestType = UltraCosmeticsData.get().getPlugin().getConfig().getString("TreasureChests.Designs." + path + ".chest-type");
        String effect = UltraCosmeticsData.get().getPlugin().getConfig().getString("TreasureChests.Designs." + path + ".effect");
        try {
            this.chestType = ChestType.valueOf(chestType.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException exc) {
            this.chestType = ChestType.NORMAL;
        }
        if (effect != null) {
            this.effect = XParticle.of((String)effect).orElse(XParticle.FLAME);
        }
    }

    private XMaterial getXMaterial(String s) {
        return ItemFactory.getNullableXMaterialFromConfig("TreasureChests.Designs." + s);
    }

    public ChestType getChestType() {
        return this.chestType;
    }

    public XMaterial getCenter() {
        return this.center;
    }

    public XMaterial getBlocks2() {
        return this.blocks2;
    }

    public XMaterial getBlocks3() {
        return this.blocks3;
    }

    public XMaterial getBarriers() {
        return this.barriers;
    }

    public XMaterial getBelowChests() {
        return this.belowChests;
    }

    public XParticle getEffect() {
        return this.effect;
    }
}

