/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.treasurechests;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.treasurechests.TreasureChest;
import be.isach.ultracosmetics.treasurechests.TreasureChestDesign;
import be.isach.ultracosmetics.treasurechests.TreasureLocation;
import be.isach.ultracosmetics.util.Area;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.SmartLogger;
import be.isach.ultracosmetics.util.StructureRollback;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class TreasureChestManager
implements Listener {
    private static final Random random = new Random();
    private final UltraCosmetics ultraCosmetics;
    private final List<TreasureLocation> TREASURE_LOCATIONS = new ArrayList<TreasureLocation>();

    public TreasureChestManager(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
        if (!SettingsManager.getConfig().getBoolean("TreasureChests.Locations.Enabled")) {
            return;
        }
        Set locationNames = SettingsManager.getConfig().getConfigurationSection("TreasureChests.Locations").getKeys(false);
        for (String locationName : locationNames) {
            if (!SettingsManager.getConfig().isConfigurationSection("TreasureChests.Locations." + locationName)) continue;
            ConfigurationSection location = SettingsManager.getConfig().getConfigurationSection("TreasureChests.Locations." + locationName);
            String worldName = location.getString("World", "none");
            World world = null;
            if (!worldName.equals("none") && (world = Bukkit.getWorld((String)worldName)) == null) {
                ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Invalid world set for location " + locationName + ", using player world");
            }
            TreasureLocation tloc = new TreasureLocation(world, location.getInt("X", 0), location.getInt("Y", 63), location.getInt("Z", 0));
            this.TREASURE_LOCATIONS.add(tloc);
        }
        if (this.TREASURE_LOCATIONS.isEmpty()) {
            ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "No treasure chest locations are defined, the setting will be ignored");
        }
    }

    private String getRandomDesign() {
        Set set = this.ultraCosmetics.getConfig().getConfigurationSection("TreasureChests.Designs").getKeys(false);
        ArrayList list = new ArrayList(set);
        return (String)list.get(random.nextInt(set.size()));
    }

    public boolean tryOpenChest(Player player) {
        if (this.TREASURE_LOCATIONS.isEmpty()) {
            this.tryOpenChest(player, null);
            return true;
        }
        ArrayList<TreasureLocation> locations = new ArrayList<TreasureLocation>(this.TREASURE_LOCATIONS);
        for (UltraPlayer up : this.ultraCosmetics.getPlayerManager().getUltraPlayers()) {
            if (up.getCurrentTreasureChest() == null) continue;
            locations.remove(up.getCurrentTreasureChest().getTreasureLocation());
        }
        if (locations.isEmpty()) {
            MessageManager.send((CommandSender)player, "Treasure-Chest-Occupied", new TagResolver.Single[0]);
            return false;
        }
        TreasureLocation tloc = (TreasureLocation)locations.get(random.nextInt(locations.size()));
        return this.tryOpenChest(player, tloc);
    }

    public boolean tryOpenChest(Player player, TreasureLocation tpTo) {
        boolean large;
        int range;
        UltraPlayer ultraPlayer = this.ultraCosmetics.getPlayerManager().getUltraPlayer(player);
        if (ultraPlayer.getCurrentTreasureChest() != null) {
            return false;
        }
        if (ultraPlayer.getKeys() < 1) {
            player.closeInventory();
            this.ultraCosmetics.getMenus().openKeyPurchaseMenu(ultraPlayer);
            return true;
        }
        if (player.getVehicle() != null) {
            MessageManager.send((CommandSender)player, "Chest-Location.Dismount-First", new TagResolver.Single[0]);
            return false;
        }
        Location targetLoc = tpTo == null ? player.getLocation() : tpTo.toLocation(player);
        Area area = new Area(targetLoc, range = (large = SettingsManager.getConfig().getBoolean("TreasureChests.Large")) ? 3 : 2, 1);
        if (!area.isEmptyExcept(targetLoc.getBlock().getLocation())) {
            MessageManager.send((CommandSender)player, "Chest-Location.Not-Enough-Space", new TagResolver.Single[0]);
            return false;
        }
        Area placeArea = new Area(targetLoc.clone().subtract(0.0, 1.0, 0.0), large ? 3 : 2, 0);
        if (StructureRollback.isBlockRollingBackInArea(placeArea)) {
            MessageManager.send((CommandSender)player, "Chest-Location.Not-Enough-Space", new TagResolver.Single[0]);
            return false;
        }
        for (Entity ent : targetLoc.getWorld().getNearbyEntities(targetLoc, (double)range, (double)range, (double)range)) {
            if (!TreasureChestManager.shouldPush(ultraPlayer, ent)) continue;
            player.closeInventory();
            MessageManager.send((CommandSender)player, "Chest-Location.Too-Close-To-Entity", new TagResolver.Single[0]);
            return false;
        }
        Block block = targetLoc.getBlock();
        if (!BlockUtils.isAir(block.getRelative(BlockFace.UP).getType()) || BlockUtils.isAir(block.getRelative(BlockFace.DOWN).getType())) {
            MessageManager.send((CommandSender)player, "Gadgets.Rocket.Not-On-Ground", new TagResolver.Single[0]);
            return false;
        }
        Location preLoc = null;
        if (tpTo != null) {
            preLoc = player.getLocation();
            tpTo.tpTo(player);
        }
        if (!this.ultraCosmetics.getWorldGuardManager().areChestsAllowedHere(player)) {
            player.closeInventory();
            MessageManager.send((CommandSender)player, "Chest-Location.Region-Disabled", new TagResolver.Single[0]);
            if (preLoc != null) {
                this.ultraCosmetics.getScheduler().teleportAsync((Entity)player, preLoc);
            }
            return false;
        }
        ultraPlayer.removeKey();
        String designPath = this.getRandomDesign();
        player.closeInventory();
        new TreasureChest(player.getUniqueId(), new TreasureChestDesign(designPath), preLoc, tpTo);
        return true;
    }

    public static boolean shouldPush(UltraPlayer chestOwner, Entity entity) {
        if (chestOwner.getBukkitPlayer() == entity || !(entity instanceof LivingEntity)) {
            return false;
        }
        if (entity instanceof ArmorStand && !((ArmorStand)entity).isVisible()) {
            return false;
        }
        if (entity.hasMetadata("NPC") || entity.hasMetadata("fake-player")) {
            return false;
        }
        return chestOwner.getCurrentPet() == null || entity != chestOwner.getCurrentPet().getEntity();
    }
}

