/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.treasurechests;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.CustomConfiguration;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.platform.bukkit.BukkitAudiences;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.treasurechests.CommandReward;
import be.isach.ultracosmetics.treasurechests.TreasureChest;
import be.isach.ultracosmetics.treasurechests.loot.AmmoLoot;
import be.isach.ultracosmetics.treasurechests.loot.CommandLoot;
import be.isach.ultracosmetics.treasurechests.loot.CommandLootContainer;
import be.isach.ultracosmetics.treasurechests.loot.CosmeticLoot;
import be.isach.ultracosmetics.treasurechests.loot.Loot;
import be.isach.ultracosmetics.treasurechests.loot.LootReward;
import be.isach.ultracosmetics.treasurechests.loot.MoneyLoot;
import be.isach.ultracosmetics.treasurechests.loot.NothingLoot;
import be.isach.ultracosmetics.util.EntitySpawner;
import be.isach.ultracosmetics.util.WeightedSet;
import com.cryptomorin.xseries.XSound;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class TreasureRandomizer {
    private final int moneyChance = SettingsManager.getConfig().getInt("TreasureChests.Loots.Money.Chance");
    private final int ammoChance = SettingsManager.getConfig().getInt("TreasureChests.Loots.Gadgets-Ammo.Chance");
    private final WeightedSet<Loot> lootTypes = new WeightedSet();
    private Location loc;
    private final Player player;
    private final boolean forceMessageToOwner;
    private final MoneyLoot money = new MoneyLoot();
    private final NothingLoot nothing = new NothingLoot();
    private final AmmoLoot ammo;
    private final boolean canAddAmmo;
    private final XSound.SoundPlayer sound = XSound.BLOCK_CHEST_OPEN.record().withVolume(1.4f).withPitch(1.5f).soundPlayer();

    public TreasureRandomizer(Player player, Location location, boolean forceMessageToOwner) {
        this.loc = location.add(0.5, 0.0, 0.5);
        this.player = player;
        this.forceMessageToOwner = forceMessageToOwner;
        this.canAddAmmo = Category.GADGETS.isEnabled() && UltraCosmeticsData.get().isAmmoEnabled() && SettingsManager.getConfig().getBoolean("TreasureChests.Loots.Gadgets-Ammo.Enabled");
        this.ammo = new AmmoLoot(player);
        if (!this.ammo.isEmpty() && this.canAddAmmo) {
            this.lootTypes.add(this.ammo, this.ammoChance);
        }
        this.initializeCommandLoot();
        for (Category cat : Category.values()) {
            this.setupChance(cat);
        }
        if (UltraCosmeticsData.get().useMoneyTreasureLoot()) {
            this.lootTypes.add(this.money, this.moneyChance);
        }
    }

    public TreasureRandomizer(Player player, Location location) {
        this(player, location, false);
    }

    private void initializeCommandLoot() {
        CustomConfiguration config = UltraCosmeticsData.get().getPlugin().getConfig();
        ConfigurationSection commandLootConfig = config.getConfigurationSection("TreasureChests.Loots.Commands");
        int globalCommandWeight = commandLootConfig.getInt("Overall-Chance", 0);
        CommandLootContainer container = null;
        if (globalCommandWeight > 0) {
            container = new CommandLootContainer();
        }
        for (String key : commandLootConfig.getKeys(false)) {
            String cancelPermission;
            if (!commandLootConfig.isConfigurationSection(key) || !commandLootConfig.getBoolean(key + ".Enabled") || !(cancelPermission = commandLootConfig.getString(key + ".Cancel-If-Permission")).equals("no") && this.player.hasPermission(cancelPermission)) continue;
            CommandReward reward = new CommandReward("TreasureChests.Loots.Commands." + key);
            if (container == null) {
                this.lootTypes.add(new CommandLoot(reward), reward.getChance());
                continue;
            }
            container.addCommandLoot(new CommandLoot(reward), reward.getChance());
        }
        if (container != null && container.getSize() > 0) {
            this.lootTypes.add(container, globalCommandWeight);
        }
    }

    private void setupChance(Category category) {
        String configPath = "TreasureChests.Loots." + category.getConfigPath();
        if (!SettingsManager.getConfig().getBoolean(configPath + ".Enabled")) {
            return;
        }
        if (!category.isEnabled()) {
            return;
        }
        int chance = SettingsManager.getConfig().getInt(configPath + ".Chance");
        if (chance <= 0) {
            return;
        }
        CosmeticLoot loot = new CosmeticLoot(category, this.player);
        if (!loot.isEmpty()) {
            this.lootTypes.add(loot, chance);
        }
    }

    private static Color randomColor() {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        return Color.fromRGB((int)((Random)r).nextInt(256), (int)((Random)r).nextInt(256), (int)((Random)r).nextInt(256));
    }

    public LootReward giveRandomThing(TreasureChest chest, boolean skipFirework) {
        UltraPlayer ultraPlayer = UltraCosmeticsData.get().getPlugin().getPlayerManager().getUltraPlayer(this.player);
        this.sound.atLocation(this.loc).play();
        if (this.lootTypes.size() == 0) {
            return this.giveFallback(ultraPlayer, chest);
        }
        Loot loot = this.lootTypes.getRandom();
        LootReward reward = loot.giveToPlayer(ultraPlayer, chest);
        this.broadcast(reward.getMessage(), reward.isBroadcast());
        if (!skipFirework && reward.isFirework()) {
            this.spawnFirework();
        }
        if (loot.isEmpty()) {
            this.lootTypes.remove(loot);
        }
        if (loot instanceof CosmeticLoot && ((CosmeticLoot)loot).getCategory() == Category.GADGETS) {
            this.ammo.add((GadgetType)reward.getCosmetic());
            if (this.canAddAmmo && !this.lootTypes.contains(this.ammo)) {
                this.lootTypes.add(this.ammo, this.ammoChance);
            }
        }
        return reward;
    }

    private LootReward giveFallback(UltraPlayer player, TreasureChest chest) {
        if (UltraCosmeticsData.get().useMoneyTreasureLoot()) {
            return this.money.giveToPlayer(player, chest);
        }
        return this.nothing.giveToPlayer(player, chest);
    }

    public void spawnFirework() {
        EntitySpawner.spawnFireworks(this.loc.clone().add(0.5, 0.0, 0.5), TreasureRandomizer.randomColor(), TreasureRandomizer.randomColor(), FireworkEffect.Type.BALL);
    }

    private void broadcast(Component message, boolean toOthers) {
        if (message == null) {
            return;
        }
        UltraCosmetics ultraCosmetics = UltraCosmeticsData.get().getPlugin();
        if (ultraCosmetics.getDiscordHook() != null) {
            ultraCosmetics.getDiscordHook().sendLootMessage(this.player, MessageManager.toLegacy(message));
        }
        BukkitAudiences audiences = MessageManager.getAudiences();
        if (!toOthers) {
            if (this.forceMessageToOwner) {
                audiences.player(this.player).sendMessage(message);
            }
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player != this.player && (!SettingsManager.isAllowedWorld(player.getWorld()) || !ultraCosmetics.getPlayerManager().getUltraPlayer(player).isTreasureNotifying())) continue;
            audiences.player(player).sendMessage(message);
        }
    }

    public void setLocation(Location newLoc) {
        this.loc = newLoc;
    }
}

