/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.util;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.SmartLogger;
import be.isach.ultracosmetics.version.VersionManager;
import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class Area {
    private final boolean DEBUG = SettingsManager.getConfig().getBoolean("Area-Debug");
    protected final World world;
    protected final int x1;
    protected final int y1;
    protected final int z1;
    protected final int x2;
    protected final int y2;
    protected final int z2;

    public Area(Location loc1, Location loc2) {
        if (loc1.getWorld() != loc2.getWorld()) {
            throw new IllegalArgumentException("Locations cannot be in different worlds");
        }
        this.world = loc1.getWorld();
        this.x1 = Math.min(loc1.getBlockX(), loc2.getBlockX());
        this.y1 = Math.min(loc1.getBlockY(), loc2.getBlockY());
        this.z1 = Math.min(loc1.getBlockZ(), loc2.getBlockZ());
        this.x2 = Math.max(loc1.getBlockX(), loc2.getBlockX());
        this.y2 = Math.max(loc1.getBlockY(), loc2.getBlockY());
        this.z2 = Math.max(loc1.getBlockZ(), loc2.getBlockZ());
    }

    public Area(Location center, int radius, int yUp) {
        this(center.clone().add((double)(-radius), 0.0, (double)(-radius)), center.clone().add((double)radius, (double)yUp, (double)radius));
    }

    public static int findMaxY(Location center, int radius) {
        World world = center.getWorld();
        int maxY = VersionManager.getWorldMaxHeight(world);
        for (int y = center.getBlockY(); y <= maxY; ++y) {
            for (int x = center.getBlockX() - radius; x <= center.getBlockX() + radius; ++x) {
                for (int z = center.getBlockZ() - radius; z <= center.getBlockZ() + radius; ++z) {
                    if (BlockUtils.isAir(world.getBlockAt(x, y, z).getType())) continue;
                    return y - 1;
                }
            }
        }
        return maxY;
    }

    public int getHeight() {
        return this.y2 - this.y1;
    }

    public boolean isEmptyExcept(int badX, int badY, int badZ, Function<Material, Boolean> okMatFunc) {
        for (int x = this.x1; x <= this.x2; ++x) {
            for (int y = this.y1; y <= this.y2; ++y) {
                for (int z = this.z1; z <= this.z2; ++z) {
                    if (x == badX && y == badY && z == badZ || okMatFunc.apply(this.world.getBlockAt(x, y, z).getType()).booleanValue()) continue;
                    if (this.DEBUG) {
                        SmartLogger log = UltraCosmeticsData.get().getPlugin().getSmartLogger();
                        log.write("Failed area check at (" + x + "," + y + "," + z + ") because it is " + String.valueOf(this.world.getBlockAt(x, y, z).getType()));
                    }
                    return false;
                }
            }
        }
        if (this.DEBUG) {
            UltraCosmeticsData.get().getPlugin().getSmartLogger().write("Area check passed");
        }
        return true;
    }

    public boolean isEmptyExcept(Location loc) {
        return this.isEmptyExcept(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), BlockUtils::isAir);
    }

    public boolean isEmpty() {
        return this.isEmptyExcept(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, BlockUtils::isAir);
    }

    public boolean isTransparent() {
        return this.isEmptyExcept(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, m -> m.isTransparent() || BlockUtils.isAir(m));
    }

    public boolean contains(Block block) {
        return block.getWorld() == this.world && this.contains(block.getX(), block.getY(), block.getZ());
    }

    public boolean contains(int x, int y, int z) {
        return x >= this.x1 && x <= this.x2 && y >= this.y1 && y <= this.y2 && z >= this.z1 && z <= this.z2;
    }

    public boolean overlapsWith(Area area) {
        return this.rangesOverlap(area.x1, area.x2, this.x1, this.x2) && this.rangesOverlap(area.y1, area.y2, this.y1, this.y2) && this.rangesOverlap(area.z1, area.z2, this.z1, this.z2);
    }

    private boolean rangesOverlap(int a1, int a2, int b1, int b2) {
        return a1 <= b2 && a2 >= b1;
    }

    public String toString() {
        return "Area{x1=" + this.x1 + ",y1=" + this.y1 + ",z1=" + this.z1 + ",x2=" + this.x2 + ",y2=" + this.y2 + ",z2=" + this.z2 + "}";
    }
}

