/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.util;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.task.UltraTask;
import be.isach.ultracosmetics.util.EntitySpawningManager;
import com.cryptomorin.xseries.XEntityType;
import com.cryptomorin.xseries.XMaterial;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class EntitySpawner<T extends Entity>
extends UltraTask {
    private static final Material FIREWORK = XMaterial.FIREWORK_ROCKET.get();
    private static final EntityType FIREWORK_ENTITY = XEntityType.FIREWORK_ROCKET.get();
    private final int limit = SettingsManager.getConfig().getInt("Max-Entity-Spawns-Per-Tick");
    private final EntityType type;
    private final Consumer<T> func;
    private final Location loc;
    private final boolean spread;
    private int remaining;
    private final Set<T> entities = new HashSet<T>();
    private boolean scheduled = false;

    public EntitySpawner(EntityType type, Location loc, int amount, boolean spread, Consumer<T> func, UltraCosmetics ultraCosmetics) {
        this.type = type;
        this.loc = loc;
        this.remaining = amount;
        this.spread = spread;
        this.func = func;
        if (this.limit < 1 || amount <= this.limit) {
            this.run();
            return;
        }
        this.schedule();
        this.scheduled = true;
    }

    public EntitySpawner(EntityType type, Location loc, int amount, Consumer<T> func, UltraCosmetics ultraCosmetics) {
        this(type, loc, amount, false, func, ultraCosmetics);
    }

    public EntitySpawner(EntityType type, Location loc, int amount, UltraCosmetics ultraCosmetics) {
        this(type, loc, amount, e -> {}, ultraCosmetics);
    }

    @Override
    public void run() {
        for (int i = 0; i < this.limit || this.limit == 0; ++i) {
            if (this.remaining < 1) {
                if (this.scheduled) {
                    this.cancel();
                }
                return;
            }
            Location spawnLoc = this.loc.clone();
            if (this.spread) {
                spawnLoc.add((double)(this.remaining % 5 - 2), 0.0, (double)(this.remaining / 4 - 2));
            }
            Entity entity = EntitySpawningManager.withBypass(() -> this.loc.getWorld().spawnEntity(spawnLoc, this.type));
            entity.setPersistent(false);
            this.func.accept(entity);
            this.entities.add(entity);
            --this.remaining;
        }
    }

    @Override
    public void schedule() {
        this.task = this.getScheduler().runAtLocationTimer(this.loc, this::run, 1L, 1L);
    }

    public Set<T> getEntities() {
        return this.entities;
    }

    public void removeEntity(Entity entity) {
        entity.remove();
        this.entities.remove(entity);
    }

    public void removeEntities() {
        for (Entity entity : this.entities) {
            entity.remove();
        }
        this.entities.clear();
        try {
            this.cancel();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public boolean isEmpty() {
        return this.entities.isEmpty();
    }

    public boolean contains(Entity entity) {
        return this.entities.contains(entity);
    }

    public static <K extends Entity> EntitySpawner<K> empty() {
        return new EntitySpawner(null, null, 0, null);
    }

    public static void spawnFireworks(Location location, Color main, Color fade, FireworkEffect.Type type) {
        HashSet<Firework> fireworks = new HashSet<Firework>();
        FireworkMeta meta = (FireworkMeta)Bukkit.getItemFactory().getItemMeta(FIREWORK);
        meta.addEffect(EntitySpawner.buildFireworkEffect(main, fade, type));
        for (int i = 0; i < 4; ++i) {
            Firework f = (Firework)location.getWorld().spawnEntity(location, FIREWORK_ENTITY);
            f.setFireworkMeta(meta);
            f.setMetadata("uc_firework", (MetadataValue)new FixedMetadataValue((Plugin)UltraCosmeticsData.get().getPlugin(), (Object)true));
            fireworks.add(f);
        }
        UltraCosmeticsData.get().getPlugin().getScheduler().runAtLocationLater(location, () -> {
            for (Firework f : fireworks) {
                f.detonate();
            }
        }, 2L);
    }

    public static void spawnFireworks(Location location, Color main, Color fade) {
        EntitySpawner.spawnFireworks(location, main, fade, FireworkEffect.Type.BALL_LARGE);
    }

    private static FireworkEffect buildFireworkEffect(Color main, Color fade, FireworkEffect.Type type) {
        FireworkEffect.Builder builder = FireworkEffect.builder();
        return builder.flicker(false).trail(false).with(type).withColor(main).withFade(fade).build();
    }
}

