/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.util;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.CustomConfiguration;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.MiniMessage;
import be.isach.ultracosmetics.util.MathUtils;
import be.isach.ultracosmetics.util.SmartLogger;
import be.isach.ultracosmetics.version.ServerVersion;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.XTag;
import com.cryptomorin.xseries.profiles.builder.XSkull;
import com.cryptomorin.xseries.profiles.objects.ProfileInputType;
import com.cryptomorin.xseries.profiles.objects.Profileable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.bukkit.util.Vector;

public class ItemFactory {
    private static final List<XMaterial> DYES = new ArrayList<XMaterial>(16);
    private static final List<XMaterial> STAINED_GLASS = new ArrayList<XMaterial>(16);
    private static final FixedMetadataValue UNPICKABLE_META = new FixedMetadataValue((Plugin)UltraCosmeticsData.get().getPlugin(), (Object)true);
    private static boolean noticePrinted;

    private ItemFactory() {
    }

    public static ItemStack create(XMaterial material, String displayName, String ... lore) {
        return ItemFactory.rename(material.parseItem(), displayName, lore);
    }

    public static ItemStack create(XMaterial material, Component displayName, String ... lore) {
        return ItemFactory.create(material, MessageManager.toLegacy(displayName), lore);
    }

    public static ItemStack rename(ItemStack itemStack, Component displayName, String ... lore) {
        return ItemFactory.rename(itemStack, MessageManager.toLegacy(displayName), lore);
    }

    public static ItemStack rename(ItemStack itemstack, String displayName, String ... lore) {
        ItemMeta meta = itemstack.getItemMeta();
        meta.setDisplayName(displayName);
        if (lore != null && lore.length > 0) {
            List finalLore = meta.hasLore() ? meta.getLore() : new ArrayList();
            for (String s : lore) {
                if (s == null) continue;
                for (String line : s.split("\n")) {
                    finalLore.add(line);
                }
            }
            meta.setLore(finalLore);
        }
        itemstack.setItemMeta(meta);
        return itemstack;
    }

    public static Item setUnpickable(Item item) {
        item.setMetadata("UNPICKABLEUP", (MetadataValue)UNPICKABLE_META);
        item.setPersistent(false);
        return item;
    }

    public static Item spawnUnpickableItem(ItemStack stack, Location loc, Vector velocity) {
        Item item = loc.getWorld().dropItem(loc, stack);
        item.setVelocity(velocity);
        ItemFactory.setUnpickable(item);
        return item;
    }

    public static Item createUnpickableItemDirectional(XMaterial material, Player player, double scale) {
        return ItemFactory.spawnUnpickableItem(material.parseItem(), player.getEyeLocation(), player.getLocation().getDirection().multiply(scale));
    }

    public static Item createUnpickableItemVariance(XMaterial material, Location loc, Random random, double variance) {
        return ItemFactory.spawnUnpickableItem(material.parseItem(), loc, new Vector(random.nextDouble() - 0.5, random.nextDouble() / 2.0, random.nextDouble() - 0.5).multiply(variance));
    }

    public static void applyCosmeticMarker(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        NamespacedKey marker = new NamespacedKey((Plugin)UltraCosmeticsData.get().getPlugin(), "marker");
        meta.getPersistentDataContainer().set(marker, PersistentDataType.BYTE, (Object)1);
        item.setItemMeta(meta);
    }

    public static ItemStack getItemStackFromConfig(String path) {
        XMaterial mat = ItemFactory.getFromConfigInternal(path);
        if (mat != null) {
            return mat.parseItem();
        }
        return ItemFactory.create(XMaterial.BEDROCK, "&cError parsing material", "&cFailed to parse material");
    }

    public static XMaterial getXMaterialFromConfig(String path) {
        XMaterial mat = ItemFactory.getFromConfigInternal(path);
        return mat == null ? XMaterial.BEDROCK : mat;
    }

    public static XMaterial getNullableXMaterialFromConfig(String path) {
        return ItemFactory.getFromConfigInternal(path);
    }

    public static List<XMaterial> getXMaterialListFromConfig(String path) {
        ArrayList<XMaterial> mats = new ArrayList<XMaterial>();
        CustomConfiguration cc = UltraCosmeticsData.get().getPlugin().getConfig();
        for (String matString : cc.getStringList(path)) {
            XMaterial.matchXMaterial((String)matString).ifPresent(mats::add);
        }
        return mats;
    }

    private static XMaterial getFromConfigInternal(String path) {
        String fromConfig = UltraCosmeticsData.get().getPlugin().getConfig().getString(path);
        if (fromConfig == null) {
            return null;
        }
        if (MathUtils.isInteger(fromConfig) || fromConfig.contains(":")) {
            if (!noticePrinted) {
                UltraCosmeticsData.get().getPlugin().getSmartLogger().write(SmartLogger.LogLevel.ERROR, "UltraCosmetics no longer supports numeric IDs, please replace it with a material name.");
                noticePrinted = true;
            }
            UltraCosmeticsData.get().getPlugin().getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Offending config path: " + path);
            return null;
        }
        return XMaterial.matchXMaterial((String)fromConfig).orElse(null);
    }

    private static ItemStack createMenuItem() {
        ConfigurationSection section = SettingsManager.getConfig().getConfigurationSection("Menu-Item");
        MiniMessage mm = MessageManager.getMiniMessage();
        String name = MessageManager.toLegacy(mm.deserialize(section.getString("Displayname")));
        int model = section.getInt("Custom-Model-Data");
        ItemStack stack = ItemFactory.rename(ItemFactory.getItemStackFromConfig("Menu-Item.Type"), name, new String[0]);
        ItemMeta meta = stack.getItemMeta();
        String rawLore = section.getString("Lore", "");
        if (!rawLore.equals("")) {
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : rawLore.split("\n")) {
                lore.add(MessageManager.toLegacy(mm.deserialize(line)));
            }
            meta.setLore(lore);
        }
        if (model != 0) {
            meta.setCustomModelData(Integer.valueOf(model));
        }
        stack.setItemMeta(meta);
        ItemFactory.applyCosmeticMarker(stack);
        return stack;
    }

    public static ItemStack getMenuItem() {
        if (!SettingsManager.getConfig().getBoolean("Menu-Item.Enabled")) {
            return null;
        }
        return ItemFactory.createMenuItem();
    }

    public static ItemStack createSkull(String url, String name) {
        ItemStack head = ItemFactory.create(XMaterial.PLAYER_HEAD, name, new String[0]);
        if (UltraCosmeticsData.get().getServerVersion().isAtLeast(ServerVersion.v1_18)) {
            SkullMeta meta = (SkullMeta)head.getItemMeta();
            PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.nameUUIDFromBytes(url.getBytes()));
            PlayerTextures textures = profile.getTextures();
            try {
                textures.setSkin(new URL("https://textures.minecraft.net/texture/" + url));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return head;
            }
            profile.setTextures(textures);
            meta.setOwnerProfile(profile);
            head.setItemMeta((ItemMeta)meta);
        } else {
            XSkull.of((ItemStack)head).profile(Profileable.of((ProfileInputType)ProfileInputType.TEXTURE_HASH, (String)url)).apply();
        }
        return head;
    }

    public static ItemStack createColouredLeather(Material armourPart, int red, int green, int blue) {
        ItemStack itemStack = new ItemStack(armourPart);
        LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStack.getItemMeta();
        leatherArmorMeta.setColor(Color.fromRGB((int)red, (int)green, (int)blue));
        itemStack.setItemMeta((ItemMeta)leatherArmorMeta);
        return itemStack;
    }

    public static void addGlow(ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.addEnchant(Enchantment.MENDING, 1, true);
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(itemMeta);
    }

    public static void setFlags(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(ItemFlag.values());
        try {
            meta.removeItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)"HIDE_LORE")});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (!meta.hasAttributeModifiers()) {
            AttributeModifier modifier = ItemFactory.createAttributeModifier("itemflags", 0.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.HAND);
            meta.addAttributeModifier(Attribute.GENERIC_KNOCKBACK_RESISTANCE, modifier);
        }
        item.setItemMeta(meta);
    }

    public static AttributeModifier createAttributeModifier(String modName, double amount, AttributeModifier.Operation operation, EquipmentSlot slot) {
        NamespacedKey key = new NamespacedKey((Plugin)UltraCosmeticsData.get().getPlugin(), modName);
        try {
            return new AttributeModifier(key, amount, operation, slot.getGroup());
        }
        catch (NoSuchMethodError error) {
            return new AttributeModifier(UUID.randomUUID(), key.toString(), amount, operation, slot);
        }
    }

    public static boolean haveSameName(ItemStack a2, ItemStack b) {
        if (a2.hasItemMeta() && b.hasItemMeta() && a2.getItemMeta().hasDisplayName() && b.getItemMeta().hasDisplayName()) {
            return a2.getItemMeta().getDisplayName().equals(b.getItemMeta().getDisplayName());
        }
        return false;
    }

    private static XMaterial randomXMaterial(List<XMaterial> mats) {
        return mats.get(ThreadLocalRandom.current().nextInt(mats.size()));
    }

    private static ItemStack randomStack(List<XMaterial> mats) {
        return ItemFactory.randomXMaterial(mats).parseItem();
    }

    public static ItemStack getRandomDye() {
        return ItemFactory.randomStack(DYES);
    }

    public static ItemStack getRandomStainedGlass() {
        return ItemFactory.randomStack(STAINED_GLASS);
    }

    public static ItemStack randomItemFromTag(XTag<XMaterial> tag) {
        return ItemFactory.randomFromTag(tag).parseItem();
    }

    public static XMaterial randomFromTag(XTag<XMaterial> tag) {
        return ItemFactory.randomXMaterial(new ArrayList<XMaterial>(tag.getValues()));
    }

    static {
        for (XMaterial mat : XMaterial.VALUES) {
            if (mat.name().endsWith("_DYE")) {
                DYES.add(mat);
                continue;
            }
            if (!mat.name().endsWith("_STAINED_GLASS")) continue;
            STAINED_GLASS.add(mat);
        }
        noticePrinted = false;
    }
}

