/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.util;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.shaded.mobchip.EntityBrain;
import be.isach.ultracosmetics.shaded.mobchip.ai.goal.CustomPathfinder;
import be.isach.ultracosmetics.shaded.mobchip.ai.goal.Pathfinder;
import be.isach.ultracosmetics.shaded.mobchip.bukkit.BukkitBrain;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;

public class PetPathfinder
extends CustomPathfinder {
    private final Player target;
    private final EntityBrain brain;
    private final double speed;
    private final boolean useEyeLocation;

    public PetPathfinder(Mob mob, Player target) {
        super(mob);
        this.target = target;
        this.brain = BukkitBrain.getBrain(mob);
        double speed = 1.15;
        boolean useEyeLocation = false;
        if (mob.getType() == EntityType.VEX) {
            speed = 0.75;
            useEyeLocation = true;
        } else if (mob instanceof Slime) {
            speed = 2.5;
        }
        this.speed = speed;
        this.useEyeLocation = useEyeLocation;
    }

    @Override
    public boolean canStart() {
        return true;
    }

    @Override
    public Pathfinder.PathfinderFlag[] getFlags() {
        return new Pathfinder.PathfinderFlag[]{Pathfinder.PathfinderFlag.MOVEMENT, Pathfinder.PathfinderFlag.JUMPING};
    }

    @Override
    public void start() {
    }

    @Override
    public void tick() {
        Location loc;
        Location location = loc = this.useEyeLocation ? this.target.getEyeLocation() : this.target.getLocation();
        if (this.entity.getWorld() != loc.getWorld()) {
            return;
        }
        if (this.entity.getLocation().distanceSquared(loc) > 100.0) {
            UltraCosmeticsData.get().getPlugin().getScheduler().teleportAsync((Entity)this.entity, loc);
            this.brain.getController().moveTo(loc, this.speed);
            return;
        }
        if (this.entity instanceof Slime) {
            Location deltaLoc = this.entity.getLocation().subtract(loc);
            double direction = -Math.atan2(deltaLoc.getX(), deltaLoc.getZ());
            float degrees = (float)(Math.toDegrees(direction) + 180.0);
            this.brain.getBody().setRotation(degrees, 0.0f);
        }
        if (loc.distanceSquared(this.entity.getLocation()) > 9.0) {
            this.brain.getController().moveTo(loc, this.speed);
        }
    }
}

