/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;

public class WeightedSet<T> {
    private Map<T, Integer> map = new HashMap<T, Integer>();

    public WeightedSet() {
    }

    public WeightedSet(WeightedSet<T> copy) {
        this.map = new HashMap<T, Integer>(copy.map);
    }

    public void add(T key, int value) {
        this.map.merge(key, value, Integer::sum);
    }

    public T getRandom() {
        int sum = this.map.values().stream().mapToInt(k -> k).sum();
        if (sum < 1) {
            return null;
        }
        int index = ThreadLocalRandom.current().nextInt(sum);
        for (Map.Entry<T, Integer> entry : this.map.entrySet()) {
            if ((index -= entry.getValue().intValue()) >= 0) continue;
            return entry.getKey();
        }
        return null;
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public void filter(Function<T, Boolean> filterFunc) {
        this.map.keySet().removeIf(filterFunc::apply);
    }

    public boolean contains(T key) {
        return this.map.containsKey(key);
    }

    public void remove(T key) {
        this.map.remove(key);
    }

    public T removeRandom() {
        T random = this.getRandom();
        this.map.remove(random);
        return random;
    }
}

