/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.v1_21_R4;

import be.isach.ultracosmetics.task.UltraTask;
import be.isach.ultracosmetics.util.MathUtils;
import be.isach.ultracosmetics.version.IEntityUtil;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Vector3f;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.level.World;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class EntityUtil
implements IEntityUtil {
    private final Random r = new Random();
    private Map<Player, Set<EntityArmorStand>> fakeArmorStandsMap = new HashMap<Player, Set<EntityArmorStand>>();
    private Map<Player, Set<Entity>> cooldownJumpMap = new HashMap<Player, Set<Entity>>();

    @Override
    public void sendBlizzard(Player player, Location loc, Predicate<Entity> canAffectFunc, Vector v) {
        Set fakeArmorStands = this.fakeArmorStandsMap.computeIfAbsent(player, k -> new HashSet());
        Set cooldownJump = this.cooldownJumpMap.computeIfAbsent(player, k -> new HashSet());
        EntityArmorStand as = new EntityArmorStand(EntityTypes.g, (World)((CraftWorld)player.getWorld()).getHandle());
        as.k(true);
        as.b(5, true);
        as.t(true);
        as.f(true);
        as.a(true);
        as.a(new Vector3f((float)this.r.nextInt(360), (float)this.r.nextInt(360), (float)this.r.nextInt(360)));
        as.a(loc.getX() + MathUtils.randomDouble(-1.5, 1.5), loc.getY() + MathUtils.randomDouble(0.0, 0.5) - 0.75, loc.getZ() + MathUtils.randomDouble(-1.5, 1.5), 0.0f, 0.0f);
        fakeArmorStands.add(as);
        PacketPlayOutSpawnEntity addPacket = new PacketPlayOutSpawnEntity(as.ao(), as.cG(), as.dA(), as.dC(), as.dG(), as.dN(), as.dL(), EntityTypes.g, 0, as.dy(), (double)as.cA());
        PacketPlayOutEntityMetadata dataPacket = new PacketPlayOutEntityMetadata(as.ao(), as.ar().b());
        ArrayList<Pair> equipment = new ArrayList<Pair>();
        equipment.add(new Pair((Object)EnumItemSlot.f, (Object)CraftItemStack.asNMSCopy((ItemStack)new ItemStack(Material.PACKED_ICE))));
        PacketPlayOutEntityEquipment equipmentPacket = new PacketPlayOutEntityEquipment(as.ao(), equipment);
        for (Player loopPlayer : player.getWorld().getPlayers()) {
            this.sendPacket(loopPlayer, (Packet<?>)addPacket);
            this.sendPacket(loopPlayer, (Packet<?>)dataPacket);
            this.sendPacket(loopPlayer, (Packet<?>)equipmentPacket);
        }
        UltraTask.runAtEntityLater((Entity)as.getBukkitEntity(), () -> {
            for (Player pl : player.getWorld().getPlayers()) {
                this.sendPacket(pl, (Packet<?>)new PacketPlayOutEntityDestroy(new int[]{as.ao()}));
            }
            fakeArmorStands.remove(as);
        }, 20L);
        as.getBukkitEntity().getNearbyEntities(0.5, 0.5, 0.5).stream().filter(ent -> !cooldownJump.contains(ent) && ent != player && canAffectFunc.test((Entity)ent)).forEachOrdered(ent -> {
            MathUtils.applyVelocity(ent, new Vector(0, 1, 0).add(v));
            cooldownJump.add(ent);
            UltraTask.runAtEntityLater((Entity)as.getBukkitEntity(), () -> cooldownJump.remove(ent), 20L);
        });
    }

    @Override
    public void clearBlizzard(Player player) {
        if (!this.fakeArmorStandsMap.containsKey(player)) {
            return;
        }
        for (EntityArmorStand as : this.fakeArmorStandsMap.get(player)) {
            if (as == null) continue;
            for (Player pl : player.getWorld().getPlayers()) {
                this.sendPacket(pl, (Packet<?>)new PacketPlayOutEntityDestroy(new int[]{as.ao()}));
            }
        }
        this.fakeArmorStandsMap.remove(player);
        this.cooldownJumpMap.remove(player);
    }

    @Override
    public void sendDestroyPacket(Player player, Entity entity) {
        this.sendPacket(player, (Packet<?>)new PacketPlayOutEntityDestroy(new int[]{((CraftEntity)entity).getHandle().ao()}));
    }

    @Override
    public void setStepHeight(Entity entity) {
        ((LivingEntity)entity).getAttribute(Attribute.STEP_HEIGHT).setBaseValue(1.0);
    }

    @Override
    public void sendTeleportPacket(Player player, Entity entity) {
        int id = entity.getEntityId();
        net.minecraft.world.entity.Entity e = ((CraftEntity)entity).getHandle();
        this.sendPacket(player, (Packet<?>)new PacketPlayOutEntityTeleport(id, PositionMoveRotation.a((net.minecraft.world.entity.Entity)e), Set.of(), e.aH));
    }

    private void sendPacket(Player player, Packet<?> packet) {
        ((CraftPlayer)player).getHandle().f.b(packet);
    }
}

