#version 130

uniform sampler2D texture;
uniform float rainStrength;

in vec2 TexCoords;

void main() {
    vec4 color = texture2D(texture, TexCoords);
    color.a *= 1.0 - rainStrength;

    float brightness = dot(color.rgb, vec3(0.333));
    if (brightness > 0.2) {
        vec3 pink = vec3(1.0, 0.3, 0.7);

        float pattern = sin(TexCoords.x * 100.0) * sin(TexCoords.y * 100.0);
        float mask = step(0.0, pattern); // 0 или 1

        color.rgb = mix(vec3(0.0), pink, mask);
    }

    /* DRAWBUFFERS:0 */
    gl_FragData[0] = color;
}
