package pokefenn.totemic.api.registry;

import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemWoodType;

/**
 * Provides access to Totemic's registries.
 * <p>
 * Use {@code TotemicAPI.get().registry()} to get an instance of this interface.
 */
public interface RegistryAPI {
    //The letter prefixes on the ResourceKeys are to make sure the RegisterEvents fire in this order. MusicInstruments need to be registered before Ceremonies.
    /** The resource key for the MusicInstrument registry. */
    static final ResourceKey<Registry<MusicInstrument>> MUSIC_INSTRUMENT_REGISTRY = ResourceKey.createRegistryKey(ResourceLocation.fromNamespaceAndPath(TotemicAPI.MOD_ID, "a_instrument"));
    /** The resource key for the TotemWoodType registry. */
    static final ResourceKey<Registry<TotemWoodType>> WOOD_TYPE_REGISTRY = ResourceKey.createRegistryKey(ResourceLocation.fromNamespaceAndPath(TotemicAPI.MOD_ID, "b_wood_type"));
    /** The resource key for the TotemCarving registry. */
    static final ResourceKey<Registry<TotemCarving>> TOTEM_CARVING_REGISTRY = ResourceKey.createRegistryKey(ResourceLocation.fromNamespaceAndPath(TotemicAPI.MOD_ID, "c_totem_carving"));
    /** The resource key for the Ceremony registry. */
    static final ResourceKey<Registry<Ceremony>> CEREMONY_REGISTRY = ResourceKey.createRegistryKey(ResourceLocation.fromNamespaceAndPath(TotemicAPI.MOD_ID, "d_ceremony"));

    /**
     * Provides access to the MusicInstrument registry.
     */
    Registry<MusicInstrument> instruments();

    /**
     * Provides access to the TotemCarving registry.
     */
    DefaultedRegistry<TotemWoodType> woodTypes();

    /**
     * Provides access to the TotemCarving registry.
     */
    DefaultedRegistry<TotemCarving> totemCarvings();

    /**
     * Provides access to the Ceremony registry.
     */
    Registry<Ceremony> ceremonies();

    /**
     * Returns the DataMapType for the "totemic:cleansing_ceremony_conversions" data map.
     * The Steve's Lullaby ceremony uses this to determine its mob conversions.
     */
    DataMapType<EntityType<?>, EntityType<? extends Mob>> cleansingCeremonyConversionsDataMap();
}
