/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic;

import java.util.concurrent.CompletableFuture;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pokefenn.totemic.TotemicConfig;
import pokefenn.totemic.advancements.ModCriteriaTriggers;
import pokefenn.totemic.apiimpl.registry.RegistryApiImpl;
import pokefenn.totemic.client.ModModelLayers;
import pokefenn.totemic.compat.kubejs.TotemicKubeEventHandler;
import pokefenn.totemic.data.TotemicAdvancementProvider;
import pokefenn.totemic.data.TotemicBlockStateProvider;
import pokefenn.totemic.data.TotemicBlockTagsProvider;
import pokefenn.totemic.data.TotemicDamageTypeTagsProvider;
import pokefenn.totemic.data.TotemicDatapackEntryProvider;
import pokefenn.totemic.data.TotemicEntityTypeTagsProvider;
import pokefenn.totemic.data.TotemicItemTagsProvider;
import pokefenn.totemic.data.TotemicLootTableProvider;
import pokefenn.totemic.data.TotemicRecipeProvider;
import pokefenn.totemic.handler.ClientInitHandlers;
import pokefenn.totemic.handler.ClientInteract;
import pokefenn.totemic.handler.ClientRenderHandler;
import pokefenn.totemic.handler.PlayerInteract;
import pokefenn.totemic.init.ModBlockEntities;
import pokefenn.totemic.init.ModBlocks;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.init.ModEntityTypes;
import pokefenn.totemic.init.ModItems;
import pokefenn.totemic.init.ModMobEffects;
import pokefenn.totemic.init.ModSounds;
import pokefenn.totemic.item.BaykokBowItem;
import pokefenn.totemic.item.MedicineBagItem;
import pokefenn.totemic.network.NetworkHandler;

@Mod(value="totemic")
public final class Totemic {
    public static final Logger logger = LogManager.getLogger(Totemic.class);

    public Totemic() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::commonSetup);
        modBus.addListener(this::gatherData);
        ModBlocks.REGISTER.register(modBus);
        ModItems.REGISTER.register(modBus);
        ModMobEffects.REGISTER.register(modBus);
        ModBlockEntities.REGISTER.register(modBus);
        ModEntityTypes.REGISTER.register(modBus);
        ModSounds.REGISTER.register(modBus);
        ModContent.INSTRUMENTS.register(modBus);
        ModContent.WOOD_TYPES.register(modBus);
        ModContent.CARVINGS.register(modBus);
        ModContent.CEREMONIES.register(modBus);
        modBus.register(ModItems.class);
        modBus.register(ModEntityTypes.class);
        modBus.register(RegistryApiImpl.class);
        modBus.addListener(ModContent::registerCustomWoodTypes);
        if (FMLEnvironment.dist.isClient()) {
            modBus.addListener(this::clientSetup);
            modBus.register(ClientInitHandlers.class);
            modBus.register(ModModelLayers.class);
        }
        if (ModList.get().isLoaded("kubejs")) {
            modBus.addListener(TotemicKubeEventHandler::onRegister);
        }
        TotemicConfig.register(ModLoadingContext.get());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModBlocks.addPlantsToFlowerPot();
            ModBlocks.setFireInfo();
            ModBlocks.addCedarSignToSignBlockEntityType();
            ModCriteriaTriggers.init();
        });
        NetworkHandler.init();
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.register(PlayerInteract.class);
        if (ModList.get().isLoaded("kubejs")) {
            eventBus.register(TotemicKubeEventHandler.class);
            TotemicKubeEventHandler.postModificationEvents();
        }
        RegistryApiImpl.createSelectorsToCeremonyMap();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ((BaykokBowItem)((Object)((Object)ModItems.baykok_bow.get()))).registerItemProperties();
            ((MedicineBagItem)((Object)((Object)ModItems.medicine_bag.get()))).registerItemProperties();
            Sheets.addWoodType((WoodType)ModBlocks.CEDAR_WOOD_TYPE);
        });
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.register(ClientInteract.class);
        eventBus.register(ClientRenderHandler.class);
    }

    private void gatherData(GatherDataEvent event) {
        ModCriteriaTriggers.init();
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper efh = event.getExistingFileHelper();
        CompletableFuture lookup = event.getLookupProvider();
        PackOutput out = gen.getPackOutput();
        TotemicBlockTagsProvider blockTP = (TotemicBlockTagsProvider)gen.addProvider(event.includeServer(), (DataProvider)new TotemicBlockTagsProvider(out, lookup, efh));
        gen.addProvider(event.includeServer(), (DataProvider)new TotemicItemTagsProvider(out, lookup, blockTP.m_274426_(), efh));
        gen.addProvider(event.includeServer(), (DataProvider)new TotemicEntityTypeTagsProvider(out, lookup, efh));
        gen.addProvider(event.includeServer(), (DataProvider)new TotemicLootTableProvider(out));
        gen.addProvider(event.includeServer(), (DataProvider)new TotemicAdvancementProvider(out, lookup, efh));
        gen.addProvider(event.includeServer(), (DataProvider)new TotemicRecipeProvider(out));
        gen.addProvider(event.includeServer(), (DataProvider)new TotemicDatapackEntryProvider(out, lookup));
        gen.addProvider(event.includeServer(), (DataProvider)new TotemicDamageTypeTagsProvider(out, lookup, efh));
        gen.addProvider(event.includeClient(), (DataProvider)new TotemicBlockStateProvider(out, efh));
    }

    public static ResourceLocation resloc(String path) {
        return new ResourceLocation("totemic", path);
    }
}

