/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.api.ceremony.StartupContext;
import pokefenn.totemic.api.event.CeremonyEvent;
import pokefenn.totemic.api.music.MusicInstrument;

public class TotemicEventHooks {
    private static final TotemicEventHooks INSTANCE = new TotemicEventHooks();

    public static TotemicEventHooks get() {
        return INSTANCE;
    }

    public CeremonySelectionResult fireCeremonySelection(LevelAccessor level, BlockPos pos, Entity initiator, List<MusicInstrument> selectors, Optional<Ceremony> ceremony) {
        CeremonyEvent.Selection event = new CeremonyEvent.Selection(level, pos, initiator, selectors, ceremony);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return new CeremonySelectionResult(event.getCeremony(), event.getSkipSelectionCheck());
    }

    public boolean fireCeremonyStartupTick(LevelAccessor level, BlockPos pos, Ceremony ceremony, CeremonyInstance instance, StartupContext context) {
        return !MinecraftForge.EVENT_BUS.post((Event)new CeremonyEvent.StartupTick(level, pos, ceremony, instance, context));
    }

    public void fireCeremonyStartupFail(LevelAccessor level, BlockPos pos, Ceremony ceremony, CeremonyInstance instance, StartupContext context) {
        MinecraftForge.EVENT_BUS.post((Event)new CeremonyEvent.StartupFail(level, pos, ceremony, instance, context));
    }

    public boolean fireCeremonyStartupSuccess(LevelAccessor level, BlockPos pos, Ceremony ceremony, CeremonyInstance instance, StartupContext context) {
        return !MinecraftForge.EVENT_BUS.post((Event)new CeremonyEvent.StartupSuccess(level, pos, ceremony, instance, context));
    }

    public CeremonyEffectResult fireCeremonyEffectTick(LevelAccessor level, BlockPos pos, Ceremony ceremony, CeremonyInstance instance, CeremonyEffectContext context) {
        CeremonyEvent.EffectTick event = new CeremonyEvent.EffectTick(level, pos, ceremony, instance, context);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        return new CeremonyEffectResult(!cancelled, event.getEffectTime());
    }

    public record CeremonySelectionResult(Optional<Ceremony> ceremony, boolean skipSelectionCheck) {
    }

    public record CeremonyEffectResult(boolean callEffect, int effectTime) {
    }
}

