/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.api;

import java.util.ServiceLoader;
import pokefenn.totemic.api.ceremony.CeremonyAPI;
import pokefenn.totemic.api.music.MusicAPI;
import pokefenn.totemic.api.registry.RegistryAPI;
import pokefenn.totemic.api.totem.TotemEffectAPI;

public abstract class TotemicAPI {
    public static final String MOD_ID = "totemic";
    private static final TotemicAPI INSTANCE = TotemicAPI.loadService();

    public static TotemicAPI get() {
        if (INSTANCE == null) {
            throw new IllegalStateException("No TotemicAPI provider found, Totemic is probably not installed");
        }
        return INSTANCE;
    }

    public abstract RegistryAPI registry();

    public abstract MusicAPI music();

    public abstract TotemEffectAPI totemEffect();

    public abstract CeremonyAPI ceremony();

    private static TotemicAPI loadService() {
        return ServiceLoader.load(TotemicAPI.class).findFirst().orElse(null);
    }
}

