/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.api.event;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.api.ceremony.StartupContext;
import pokefenn.totemic.api.music.MusicInstrument;

public abstract class CeremonyEvent
extends Event {
    private final LevelAccessor level;
    private final BlockPos pos;
    private final Ceremony ceremony;
    private final CeremonyInstance instance;

    public CeremonyEvent(LevelAccessor level, BlockPos pos, Ceremony ceremony, CeremonyInstance instance) {
        this.level = level;
        this.pos = pos;
        this.ceremony = ceremony;
        this.instance = instance;
    }

    public LevelAccessor getLevel() {
        return this.level;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Ceremony getCeremony() {
        return this.ceremony;
    }

    public CeremonyInstance getCeremonyInstance() {
        return this.instance;
    }

    @Cancelable
    public static class EffectTick
    extends CeremonyEvent {
        private final CeremonyEffectContext context;
        private int effectTime;

        public EffectTick(LevelAccessor level, BlockPos pos, Ceremony ceremony, CeremonyInstance instance, CeremonyEffectContext context) {
            super(level, pos, ceremony, instance);
            this.context = context;
            this.effectTime = instance.getEffectTime();
        }

        public CeremonyEffectContext getContext() {
            return this.context;
        }

        public int getEffectTime() {
            return this.effectTime;
        }

        public void setEffectTime(int effectTime) {
            this.effectTime = effectTime;
        }
    }

    @Cancelable
    public static class StartupSuccess
    extends CeremonyEvent {
        private final StartupContext context;

        public StartupSuccess(LevelAccessor level, BlockPos pos, Ceremony ceremony, CeremonyInstance instance, StartupContext context) {
            super(level, pos, ceremony, instance);
            this.context = context;
        }

        public StartupContext getContext() {
            return this.context;
        }
    }

    public static class StartupFail
    extends CeremonyEvent {
        private final StartupContext context;

        public StartupFail(LevelAccessor level, BlockPos pos, Ceremony ceremony, CeremonyInstance instance, StartupContext context) {
            super(level, pos, ceremony, instance);
            this.context = context;
        }

        public StartupContext getContext() {
            return this.context;
        }
    }

    @Cancelable
    public static class StartupTick
    extends CeremonyEvent {
        private final StartupContext context;

        public StartupTick(LevelAccessor level, BlockPos pos, Ceremony ceremony, CeremonyInstance instance, StartupContext context) {
            super(level, pos, ceremony, instance);
            this.context = context;
        }

        public StartupContext getContext() {
            return this.context;
        }
    }

    public static class Selection
    extends Event {
        private final LevelAccessor level;
        private final BlockPos pos;
        private final Entity initiator;
        private final List<MusicInstrument> selectors;
        private Optional<Ceremony> ceremony;
        private boolean skipSelectionCheck = false;

        public Selection(LevelAccessor level, BlockPos pos, Entity initiator, List<MusicInstrument> selectors, Optional<Ceremony> ceremony) {
            this.level = level;
            this.pos = pos;
            this.initiator = initiator;
            this.selectors = selectors;
            this.ceremony = ceremony;
        }

        public LevelAccessor getLevel() {
            return this.level;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public Entity getInitiator() {
            return this.initiator;
        }

        public List<MusicInstrument> getSelectors() {
            return Collections.unmodifiableList(this.selectors);
        }

        public Optional<Ceremony> getCeremony() {
            return this.ceremony;
        }

        public void setCeremony(@Nullable Ceremony ceremony) {
            this.ceremony = Optional.ofNullable(ceremony);
        }

        public boolean getSkipSelectionCheck() {
            return this.skipSelectionCheck;
        }

        public void setSkipSelectionCheck(boolean skipSelectionCheck) {
            this.skipSelectionCheck = skipSelectionCheck;
        }
    }
}

