/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.api.totem;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.totem.TotemEffect;

public final class TotemCarving {
    public static final int MEDICINE_BAG_DRAIN_INTERVAL = 80;
    public static final int DEFAULT_MEDICINE_BAG_DRAIN = 80;
    private List<TotemEffect> effects;
    private int medicineBagDrain = 80;
    @Nullable
    private String descriptionId;

    public static TotemCarving of(TotemEffect effect) {
        return new TotemCarving(List.of(effect));
    }

    public static TotemCarving of(TotemEffect ... effects) {
        return new TotemCarving(List.of(effects));
    }

    public static TotemCarving of(List<TotemEffect> effects) {
        return new TotemCarving(List.copyOf(effects));
    }

    private TotemCarving(List<TotemEffect> effects) {
        this.effects = effects;
    }

    public String getDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.m_137492_((String)"totemic.totem", (ResourceLocation)this.getRegistryName());
        }
        return this.descriptionId;
    }

    public MutableComponent getDisplayName() {
        return Component.m_237115_((String)this.getDescriptionId());
    }

    public final ResourceLocation getRegistryName() {
        return TotemicAPI.get().registry().totemCarvings().getKey((Object)this);
    }

    public List<TotemEffect> getEffects() {
        return this.effects;
    }

    public boolean supportsMedicineBag() {
        return this.effects.stream().allMatch(TotemEffect::supportsMedicineBag);
    }

    public int getMedicineBagDrain() {
        return this.medicineBagDrain;
    }

    public TotemCarving setEffects(List<? extends TotemEffect> effects) {
        this.effects = List.copyOf(effects);
        return this;
    }

    public TotemCarving setMedicineBagDrain(int drain) {
        if (drain < 0) {
            throw new IllegalArgumentException("The drain amount must be non-negative: " + drain);
        }
        this.medicineBagDrain = drain;
        return this;
    }

    public String toString() {
        return this.getRegistryName().toString();
    }
}

