/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.music;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.util.BlockUtil;

public class DrumBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty PLAYED = BooleanProperty.m_61465_((String)"played");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.8125, (double)0.8125);

    public DrumBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PLAYED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult res) {
        this.playMusic(state, level, pos, player);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        this.playMusic(state, level, pos, player);
    }

    private void playMusic(BlockState state, Level level, BlockPos pos, Player player) {
        if (!((Boolean)state.m_61143_((Property)PLAYED)).booleanValue()) {
            if (!player.m_6144_()) {
                this.putOnCooldown(state, level, pos);
                TotemicAPI.get().music().playMusic(level, pos, (Entity)player, (MusicInstrument)ModContent.drum.get());
            } else {
                this.putOnCooldown(state, level, pos);
                TotemicAPI.get().music().playSelector(level, pos, (Entity)player, (MusicInstrument)ModContent.drum.get());
            }
        }
    }

    private void putOnCooldown(BlockState state, Level level, BlockPos pos) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)PLAYED, (Comparable)Boolean.valueOf(true)), 3);
        level.m_186460_(pos, (Block)this, 20);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)PLAYED, (Comparable)Boolean.valueOf(false)), 3);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PLAYED, WATERLOGGED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(BlockUtil.placedInWater(context)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter world, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        BlockUtil.scheduleWaterloggedTick(pState, pCurrentPos, pLevel);
        return pState;
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

