/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.totem.entity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.TotemicEventHooks;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.api.music.MusicAcceptor;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.apiimpl.registry.RegistryApiImpl;
import pokefenn.totemic.block.totem.entity.StateStartup;
import pokefenn.totemic.block.totem.entity.StateTotemEffect;
import pokefenn.totemic.block.totem.entity.TotemBaseBlockEntity;
import pokefenn.totemic.block.totem.entity.TotemState;
import pokefenn.totemic.client.CeremonyHUD;
import pokefenn.totemic.util.MiscUtil;

public final class StateSelection
extends TotemState {
    static final byte ID = 1;
    private StateTotemEffect previousState;
    private final List<MusicInstrument> selectors = new ArrayList<MusicInstrument>(2);
    private int time = 0;

    StateSelection(TotemBaseBlockEntity tile, StateTotemEffect previousState) {
        super(tile);
        this.previousState = previousState;
    }

    StateSelection(TotemBaseBlockEntity tile) {
        this(tile, new StateTotemEffect(tile));
    }

    @Override
    public boolean canSelect() {
        return true;
    }

    @Override
    public void addSelector(@Nonnull Entity entity, MusicInstrument instr) {
        MiscUtil.spawnAlwaysVisibleServerParticles((ParticleOptions)ParticleTypes.f_123758_, this.tile.m_58904_(), this.getPosition(), 6, new Vec3(0.5, 0.5, 0.5), 0.0);
        MiscUtil.spawnAlwaysVisibleServerParticles((ParticleOptions)ParticleTypes.f_123815_, this.tile.m_58904_(), this.getPosition(), 16, new Vec3(0.6, 0.5, 0.6), 0.0);
        this.selectors.add(instr);
        this.time = 0;
        this.tile.m_6596_();
        if (this.selectors.size() >= 2) {
            TotemicEventHooks.CeremonySelectionResult eventResult = TotemicEventHooks.get().fireCeremonySelection((LevelAccessor)this.tile.m_58904_(), this.tile.m_58899_(), entity, this.selectors, RegistryApiImpl.getCeremony(this.selectors));
            eventResult.ceremony().ifPresentOrElse(ceremony -> {
                CeremonyInstance instance = ceremony.createInstance();
                if (eventResult.skipSelectionCheck() || instance.canSelect(this.tile.m_58904_(), this.tile.m_58899_(), entity)) {
                    this.tile.setTotemState(new StateStartup(this.tile, (Ceremony)ceremony, instance, entity));
                } else {
                    this.resetTotemState();
                }
            }, () -> this.resetTotemState());
        }
    }

    @Override
    public boolean canAcceptMusic(MusicInstrument instr) {
        return false;
    }

    @Override
    public MusicAcceptor.MusicResult acceptMusic(MusicInstrument instr, int amount, Vec3 from, @Nullable Entity entity) {
        return MusicAcceptor.MusicResult.FAILURE;
    }

    @Override
    public int getPriority() {
        return 16;
    }

    @Override
    public void tick() {
        if (!this.tile.m_58904_().f_46443_) {
            if (this.time++ >= 1200) {
                this.tile.setTotemState(this.previousState);
            }
        } else {
            CeremonyHUD.INSTANCE.setActiveTotem(this.tile);
        }
    }

    public List<MusicInstrument> getSelectors() {
        return this.selectors;
    }

    @Override
    void resetTotemState() {
        MiscUtil.spawnAlwaysVisibleServerParticles((ParticleOptions)ParticleTypes.f_123755_, this.tile.m_58904_(), this.getPosition(), 16, new Vec3(0.6, 0.5, 0.6), 0.0);
        this.tile.setTotemState(this.previousState);
    }

    @Override
    byte getID() {
        return 1;
    }

    @Override
    void save(CompoundTag tag) {
        ListTag selectorsTag = new ListTag();
        for (MusicInstrument instr : this.selectors) {
            selectorsTag.add((Object)StringTag.m_129297_((String)instr.getRegistryName().toString()));
        }
        tag.m_128365_("Selectors", (Tag)selectorsTag);
        tag.m_128405_("Time", this.time);
        this.previousState.save(tag);
    }

    @Override
    void load(CompoundTag tag) {
        this.selectors.clear();
        ListTag selectorsTag = tag.m_128437_("Selectors", 8);
        for (int i = 0; i < selectorsTag.size(); ++i) {
            String name = selectorsTag.m_128778_(i);
            MusicInstrument instr = (MusicInstrument)TotemicAPI.get().registry().instruments().getValue(ResourceLocation.m_135820_((String)name));
            if (instr != null) {
                this.selectors.add(instr);
                continue;
            }
            Totemic.logger.error("Unknown music instrument: '{}'", (Object)name);
        }
        this.time = tag.m_128451_("Time");
        this.previousState.load(tag);
    }
}

